/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao.integral;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Utilitarios;
import igraf.moduloJanelasAuxiliares.controle.JanelaIntegralController;
import igraf.moduloJanelasAuxiliares.visao.integral.PainelIntegral;
import igraf.moduloJanelasAuxiliares.visao.integral.PainelOpcoesIntegracao;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class JanelaIntegral
extends Frame
implements LanguageUpdatable {
    private JanelaIntegralController janelaIntegralController;
    private PainelIntegral painelIntegral;
    private PainelOpcoesIntegracao painelOpcoesIntegracao;
    private Panel painelAuxiliar;
    private double delta = 0.02;
    private double from = 0.0;
    private double to = 1.0;
    private final int ESQUERDA = 37;
    private final int DIREITA = 39;
    private final int BAIXO = 40;
    private final int CIMA = 38;

    public JanelaIntegral(JanelaIntegralController janelaIntegralController) {
        super(ResourceReader.msg("janIntegTit"));
        this.janelaIntegralController = janelaIntegralController;
        this.painelIntegral = new PainelIntegral(janelaIntegralController);
        this.painelOpcoesIntegracao = new PainelOpcoesIntegracao(this.painelIntegral);
        this.setLayout(new GridLayout(1, 2));
        this.painelAuxiliar = new Panel(new GridLayout(1, 2)){

            public Dimension getPreferredSize() {
                return new Dimension(396, 200);
            }
        };
        this.painelAuxiliar.add(this.painelIntegral);
        this.painelAuxiliar.add(this.painelOpcoesIntegracao);
        this.add(this.painelAuxiliar);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JanelaIntegral.this.setVisible(false);
                JanelaIntegral.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public Choice getChoiceUm() {
        return this.painelIntegral.cp1.getChoice();
    }

    public Choice getChoiceDois() {
        return this.painelIntegral.cp2.getChoice();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        TextField textField = (TextField)keyEvent.getSource();
        double d = this.getValue(textField);
        if (n == 37 || n == 40) {
            textField.setText(Utilitarios.precisao(d -= this.delta));
        }
        if (n == 39 || n == 38) {
            textField.setText(Utilitarios.precisao(d += this.delta));
        }
        if (textField.getName().equals("inf")) {
            this.from = d;
        }
        if (textField.getName().equals("sup")) {
            this.to = d;
        }
    }

    public double getValue(TextField textField) {
        String string = textField.getText();
        string = Analisa.verificaConstante(string);
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public double getFrom() {
        return this.from;
    }

    public double getTo() {
        return this.to;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void updateLabels() {
        this.setTitle(ResourceReader.msg("janIntegTit"));
        this.painelIntegral.updateLabels();
        this.painelOpcoesIntegracao.updateLabels();
    }
}

