/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.controle;

import difusor.CommunicationFacade;
import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.moduloCentral.eventos.GraphicOnScreenChangedEvent;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.desenho.DesenhoFuncao;
import java.awt.Choice;
import java.util.Vector;

public abstract class JanelaController
extends CommunicationController {
    public static final String IGCLASSPATH = "src/igraf/moduloJanelasAuxiliares/controle/JanelaController.java";
    protected Vector listaDesenho;
    protected Vector listaFuncao;

    public JanelaController(CommunicationFacade communicationFacade, boolean bl) {
        super(communicationFacade, bl);
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        if (communicationEvent.getCommand().equals("screen changed")) {
            GraphicOnScreenChangedEvent graphicOnScreenChangedEvent = (GraphicOnScreenChangedEvent)communicationEvent;
            this.listaDesenho = graphicOnScreenChangedEvent.getListaDesenhoVisivel();
            this.listaFuncao = graphicOnScreenChangedEvent.getListaFuncaoVisivel();
        }
    }

    public void preencheChoiceFuncoes(Choice choice) {
        try {
            int n = choice.getSelectedIndex();
            choice.removeAll();
            for (int i = 0; i < this.listaFuncao.size(); ++i) {
                choice.add(((DesenhoFuncao)this.listaFuncao.elementAt(i)).getFuncaoAtual());
            }
            choice.getParent().validate();
            choice.select(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void preencheChoiceDesenho(Choice choice) {
        try {
            int n = choice.getSelectedIndex();
            choice.removeAll();
            for (int i = 0; i < this.listaDesenho.size(); ++i) {
                Desenho desenho = (Desenho)this.listaDesenho.get(i);
                choice.add(desenho.toString());
            }
            choice.getParent().validate();
            if (n > 0) {
                choice.select(n);
            }
        }
        catch (Exception exception) {
            System.err.println("src/igraf/moduloJanelasAuxiliares/controle/JanelaController.java: preencheChoiceDesenho(Choice): " + exception.toString());
        }
    }

    public String[] getListaDesenho() {
        String[] stringArray = new String[this.listaDesenho.size()];
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            Desenho desenho = (Desenho)this.listaDesenho.get(i);
            stringArray[i] = desenho.toString();
        }
        return stringArray;
    }
}

