/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.modelo;

import igraf.basico.io.ResourceReader;
import igraf.moduloExercicio.visao.PainelResposta;
import igraf.moduloExercicio.visao.PainelRespostaAlgebrica;
import igraf.moduloExercicio.visao.PainelRespostaIntervalo;
import igraf.moduloExercicio.visao.PainelRespostaNumerica;
import igraf.moduloExercicio.visao.PainelRespostaPonto;

public class Acao {
    private static final String[] listaAcaoDesenho = new String[]{"DESENHO_INDIVIDUAL", "DESENHO_MULTIPLO", "ESCONDER_ULTIMO_GRAFICO", "DELETAR_GRAFICO_SELECIONADO", "DELETAR_TODOS_GRAFICOS", "ESCONDER_TODOS_GRAFICOS", "EDITAR_FUNCAO", "INSERIR_ABA", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "POLIGONO", "UNDO_POLIGONO", "REDO_POLIGONO"};
    private static final String[] listaAcaoAnimacao = new String[]{"ANIMACAO", "RASTRO_NA_TELA", "AUMENTAR_VELOCIDADE_ANIMACAO", "DIMINUIR_VELOCIDADE_ANIMACAO"};
    private static final String[] listaAcaoEixos = new String[]{"EIXOS", "ESCALA", "GRADE", "DESLOCAR_ORIGEM"};
    private static final String[] listaAcaoCalculo = new String[]{"TRACAR_DERIVADA", "TRACAR_TANGENTE", "CALCULAR_INTEGRAL", "INT_INDEFINIDA"};
    private static final String[] listaAcaoZoom = new String[]{"MAIS_ZOOM", "MENOS_ZOOM", "ZOOM_PADRAO"};
    private static final String[] listaAcaoTexto = new String[]{"INSERE_TEXTO", "APAGA_TEXTO", "EDITA_TEXTO", "ATUALIZA_POSICAO_TEXTO"};
    private static final String[] listaAcaoExercicio = new String[]{"HABILITA_ENVIO_RESPOSTA", "RESPOSTA_NUMERICA", "RESPOSTA_ALGEBRICA", "RESPOSTA_PONTO", "RESPOSTA_INTERVALO", "INSERIR_COMENTARIO", "HABILITA_VISAO_RESPOSTA", "RESPOSTA_OBJETIVA", "RESPOSTA_DISCURSIVA", "DESABILITA_MENU", "INSERIR_COMENTARIO_ALUNO"};
    private static String[][] matrizAcao = new String[][]{listaAcaoDesenho, listaAcaoAnimacao, listaAcaoEixos, listaAcaoCalculo, listaAcaoZoom, listaAcaoTexto, listaAcaoExercicio};
    public static final int desenhar = 0;
    public static final int desenharTodos = 1;
    public static final int apagarUltimo = 2;
    public static final int apagarGrafico = 3;
    public static final int removerTodos = 4;
    public static final int apagarTodos = 5;
    public static final int editarFuncao = 6;
    public static final int inserirAba = 7;
    public static final int criarPoligono = 30;
    public static final int desfazerPoligono = 31;
    public static final int refazerPoligono = 32;
    public static final int animar = 100;
    public static final int deixarRastro = 101;
    public static final int aumentarVelocidade = 102;
    public static final int diminuirVelocidade = 103;
    public static final int exibirEixos = 200;
    public static final int exibirEscala = 201;
    public static final int exibirGrade = 202;
    public static final int deslocarOrigem = 203;
    public static final int derivar = 300;
    public static final int desenhaTangente = 301;
    public static final int intDefinida = 302;
    public static final int intIndefinida = 303;
    public static final int mudaPlanoCartesiano = 400;
    public static final int diminuirZoom = 401;
    public static final int zoomPadrao = 402;
    public static final int inserirTexto = 500;
    public static final int apagarTexto = 501;
    public static final int editarTexto = 502;
    public static final int atualizarPosicaoTexto = 503;
    public static final int habilitarEnvioResposta = 600;
    public static final int respostaNumerica = 601;
    public static final int respostaAlgebrica = 602;
    public static final int respostaPonto = 603;
    public static final int respostaIntervalo = 604;
    public static final int inserirComentario = 605;
    public static final int habilitarVisaoResposta = 606;
    public static final int respostaObjetiva = 607;
    public static final int respostaDiscursiva = 608;
    public static final int desabilitaMenu = 609;
    public static final int inserirComentarioAluno = 610;
    private int codigoAcao;
    private int linhaAcao;
    private int colunaAcao;
    private String descricao;
    private String listaArg;

    private Acao(int n) {
        this.codigoAcao = n;
        this.linhaAcao = n / 100;
        this.colunaAcao = n % 100;
        this.descricao = ResourceReader.msg(matrizAcao[this.linhaAcao][this.colunaAcao]);
    }

    public Acao(int n, String string) {
        this(n);
        this.listaArg = string;
    }

    public static boolean ehExercicio(int n) {
        return n >= 600 && n <= 605;
    }

    public static int acaoDeResposta(PainelResposta painelResposta) {
        if (painelResposta instanceof PainelRespostaAlgebrica) {
            return 602;
        }
        if (painelResposta instanceof PainelRespostaIntervalo) {
            return 604;
        }
        if (painelResposta instanceof PainelRespostaNumerica) {
            return 601;
        }
        if (painelResposta instanceof PainelRespostaPonto) {
            return 603;
        }
        return -1;
    }

    public String getListaArg() {
        return this.listaArg;
    }

    public int getCodigoAcao() {
        return this.codigoAcao;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String toString() {
        return String.valueOf(this.codigoAcao) + " " + this.listaArg;
    }

    public String getAcaoAsString() {
        String string = Integer.toString(this.codigoAcao);
        String string2 = "{";
        if (this.codigoAcao < 100) {
            string2 = string2 + "0";
        }
        if (this.codigoAcao < 10) {
            string2 = string2 + "0";
        }
        String string3 = string2 + string + ", " + this.getDescricao() + ", " + this.getListaArg() + "}\r\n";
        return string3;
    }

    public void setListaArg(String string) {
        this.listaArg = string;
    }
}

