/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.desenho;

import difusor.evento.CommunicationEvent;
import igraf.moduloCentral.controle.desenho.DesenhoController;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.plotter.GraphPlotter;
import java.util.Vector;

public class DesenhoFuncaoController
extends DesenhoController {
    protected Vector listaDesenhoOculto = new Vector();

    public DesenhoFuncaoController(GraphPlotter graphPlotter) {
        super(graphPlotter);
    }

    public void trataEvento(CommunicationEvent communicationEvent) {
    }

    public boolean insereDesenho(Desenho desenho) {
        int n = this.indexOfFunctionOffScreen(desenho.toString());
        if (n > -1 & this.ehDesenhoVisivel(desenho.toString())) {
            return false;
        }
        if (n < 0) {
            this.listaDesenhoOculto.addElement(desenho);
            this.listaDesenho.add(desenho);
        } else if (!this.ehDesenhoVisivel(desenho.getFuncaoAtual())) {
            desenho.setColorIndex(n);
            this.listaDesenho.add(desenho);
        }
        this.notificaAlteracaoEstado();
        return true;
    }

    private int indexOfFunctionOffScreen(String string) {
        for (int i = 0; i < this.listaDesenhoOculto.size(); ++i) {
            Desenho desenho = (Desenho)this.listaDesenhoOculto.elementAt(i);
            if (!desenho.toString().equals(string)) continue;
            return desenho.getOrdem();
        }
        return -1;
    }

    public void desenharTodos() {
        for (int i = 0; i < this.listaDesenhoOculto.size(); ++i) {
            this.insereDesenho((Desenho)this.listaDesenhoOculto.get(i));
        }
    }

    public Vector getListaDesenhoOculto() {
        return this.listaDesenhoOculto;
    }

    public int getNumDesenhoOculto() {
        return this.listaDesenhoOculto.size();
    }

    public Desenho getDesenhoOculto(int n) {
        return (Desenho)this.listaDesenhoOculto.get(n);
    }

    public void ocultaTodosGraficos() {
        this.listaDesenho.removeAllElements();
        this.notificaAlteracaoEstado();
    }

    public void ocultaDesenho(Desenho desenho) {
        this.listaDesenho.remove(desenho);
        this.notificaAlteracaoEstado();
    }

    public void removeDesenho(Desenho desenho) {
        this.listaDesenhoOculto.remove(desenho);
        this.listaDesenho.remove(desenho);
        this.notificaAlteracaoEstado();
    }

    public void removerTodos() {
        this.listaDesenhoOculto.removeAllElements();
        this.listaDesenho.removeAllElements();
        this.notificaAlteracaoEstado();
    }

    public void notificaAlteracaoEstado() {
        IgrafTabUpdateEvent igrafTabUpdateEvent = new IgrafTabUpdateEvent(this, "changeFunctionList");
        igrafTabUpdateEvent.notificaDesenhoOculto(this.getNumDesenhoOculto() > 0);
        igrafTabUpdateEvent.setFunctionList(this.listaDesenho);
        this.enviarEvento(igrafTabUpdateEvent);
    }

    public void reset() {
        super.reset();
        this.listaDesenhoOculto.removeAllElements();
    }
}

