/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloAjuda.visao.navegador;

import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloAjuda.visao.navegador.ItemNavigator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class NavigatorLabel
extends JLabel
implements MouseListener {
    private static final Color colorForeActive = EsquemaVisual.corLetrasAtivoBotoes;
    private static final Color colorFore = EsquemaVisual.corLetrasBotoes;
    private static final Color colorBack = EsquemaVisual.corFundoBotoes;
    private static final Color colorMoseOver = EsquemaVisual.corAcesa;
    private static final int WIDTH = 118;
    private static final int HEIGHT = 40;
    private ItemNavigator itemNavigator;
    private int index;
    private boolean selecionado;
    public String name;

    public NavigatorLabel(String string, int n, ItemNavigator itemNavigator) {
        super("   " + ResourceReader.msg(string));
        this.index = n;
        this.itemNavigator = itemNavigator;
        this.name = string;
        this.setPreferredSize(new Dimension(118, 40));
        this.setOpaque(true);
        this.setFont(EsquemaVisual.fontHB12);
        this.setStandardColors();
        this.addMouseListener(this);
    }

    private void setStandardColors() {
        this.setForeground(colorFore);
        this.setBackground(colorBack);
    }

    void selecionaLabel(int n) {
        if (n == this.index) {
            this.setForeground(colorForeActive);
            this.setBackground(colorBack);
            this.selecionado = true;
        } else {
            this.setStandardColors();
            this.selecionado = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.itemNavigator.setConteudoAjuda(this.index);
        this.selecionaLabel(this.index);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.selecionado) {
            this.setForeground(colorMoseOver);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.selecionado) {
            this.setStandardColors();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

