/*
 * Decompiled with CFR 0.152.
 */
package moduloColor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import moduloColor.ColorChangeListener;
import moduloColor.ColorController;
import moduloColor.ColorEvent;

public class ColorFrame
extends JFrame
implements ChangeListener {
    JColorChooser chooser = new JColorChooser();
    private ColorChangeListener listener;
    private ColorController controller;

    public ColorFrame(ColorController colorController) {
        this();
        this.controller = colorController;
    }

    public ColorFrame(ColorChangeListener colorChangeListener) {
        this();
        this.listener = colorChangeListener;
    }

    public ColorFrame() {
        this.setSize(new Dimension(450, 360));
        this.chooser.getSelectionModel().addChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorFrame.this.notificaFechamento();
            }
        });
        this.add(this.chooser);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Color color = this.chooser.getColor();
        if (this.controller != null) {
            this.controller.enviarEvento(new ColorEvent((Object)this, color));
        } else {
            this.listener.updateColor(new ColorEvent((Object)this, color));
        }
    }

    private void notificaFechamento() {
        if (this.controller != null) {
            this.controller.enviarEvento(new ColorEvent((Object)this, "close color pane"));
        }
    }
}

