/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao.animacao;

import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.visao.desenho.DesenhoAnimacao;
import igraf.moduloJanelasAuxiliares.controle.JanelaAnimacaoController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelAnimacao
extends JPanel
implements ItemListener {
    private static final int CHKW = 20;
    private static final int CHKH = 20;
    private static final Color bgColor = EsquemaVisual.corBackground;
    private static final Color corNotAnimation = Color.gray;
    public static final Font fontHB11 = EsquemaVisual.fontHB11;
    private JCheckBox chkBox = null;
    private JLabel labelToFunc;
    private boolean checked = true;
    private boolean apagado;
    private int index;
    private Color corFuncao;
    private String strNameFunction;
    private JanelaAnimacaoController janelaAnimacaoController;
    private DesenhoAnimacao desenhoAnimacao;

    public LabelAnimacao(int n, String string, JanelaAnimacaoController janelaAnimacaoController) {
        this.index = n;
        this.strNameFunction = string;
        this.janelaAnimacaoController = janelaAnimacaoController;
        this.createPanel(string);
    }

    private void createPanel(String string) {
        this.setLayout(new BorderLayout());
        this.chkBox = new JCheckBox("", true);
        this.chkBox.setName(String.valueOf(this.index));
        this.chkBox.setHorizontalAlignment(2);
        this.chkBox.addItemListener(this);
        this.labelToFunc = new JLabel(string);
        this.labelToFunc.setBackground(bgColor);
        this.labelToFunc.setHorizontalAlignment(2);
        this.labelToFunc.setFont(fontHB11);
        this.chkBox.setBackground(bgColor);
        this.setBackground(bgColor);
        this.add("West", this.chkBox);
        this.add("Center", this.labelToFunc);
        this.setBorder(BorderFactory.createBevelBorder(0, Color.black, Color.lightGray));
        this.hasFunction(false);
    }

    public void setCorFuncao(Color color) {
        this.corFuncao = color;
        this.labelToFunc.setForeground(color);
    }

    protected void resetText() {
        this.labelToFunc.setText("");
    }

    public void setDesenhoAnimacao(DesenhoAnimacao desenhoAnimacao, String string) {
        this.desenhoAnimacao = desenhoAnimacao;
        this.labelToFunc.setText("");
        this.labelToFunc.setText(this.strNameFunction + " = " + string);
        this.hasFunction(true);
    }

    public String getText() {
        if (this.labelToFunc == null || this.labelToFunc.getText() == null) {
            return null;
        }
        String string = this.labelToFunc.getText();
        if (string.length() < 9) {
            return string;
        }
        return this.labelToFunc.getText().substring(9);
    }

    public boolean isChecked() {
        return this.checked;
    }

    private void changeCheckedState() {
        this.checked = !this.checked;
        boolean bl = this.apagado = !this.apagado;
        if (this.apagado) {
            this.labelToFunc.setForeground(this.corFuncao);
        } else {
            this.labelToFunc.setForeground(corNotAnimation);
        }
    }

    private void hasFunction(boolean bl) {
        this.apagado = bl;
        if (this.apagado) {
            this.labelToFunc.setForeground(this.corFuncao);
        } else {
            this.labelToFunc.setForeground(Color.lightGray);
        }
        this.checked = bl;
        this.chkBox.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.changeCheckedState();
        this.desenhoAnimacao.animate(this.checked);
    }

    public void resetLabel() {
        this.labelToFunc.setText(this.strNameFunction);
    }
}

