/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao;

import difusor.i18N.LanguageUpdatable;
import igraf.IGraf;
import igraf.basico.event.AttentionToolTip;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.basico.util.Funcao;
import igraf.moduloExercicio.visao.JanelaExercicio;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class PainelResposta
extends JPanel
implements LanguageUpdatable {
    protected static final int WIDTH = 500;
    protected static final int HEIGHT = 25;
    protected static final int WIDTHLABEL = 100;
    protected static final Font fonte = new Font("Arial", 0, 10);
    private float precisao = 0.01f;
    double ERROMAX = 0.011;
    protected int numQuest;
    protected int numAcertos = 0;
    protected int numErros = 0;
    protected int maxNumError;
    protected String numResp;
    protected String diagnostico = "";
    private String valorResposta;
    private String valorCorrecao;
    protected String semAcertos = ResourceReader.msg("tentNaoCert");
    protected String acertoTotal = ResourceReader.msg("tentTotCert");
    protected String acertoParcial = ResourceReader.msg("tentParCert");
    private Vector listaDiagnostico;
    private JLabel labelPanel;
    private JLabel labelNumberOfAnswers;
    private JPanel panelLeft;
    private JPanel panelRight;
    protected JanelaExercicio janelaExercicio;

    public abstract int comparaResposta();

    protected abstract void configurePanelAtRight();

    public abstract boolean validar();

    public abstract void limparCampos();

    public PainelResposta() {
        this.setLayout(new GridLayout(1, 2, 3, 3));
        this.listaDiagnostico = new Vector();
        this.panelLeft = new JPanel();
        this.panelLeft.setLayout(new BorderLayout());
        this.add(this.panelLeft);
        this.panelRight = new JPanel(new GridLayout(1, 1));
        this.add(this.panelRight);
        this.labelPanel = new JLabel();
        this.labelPanel.setForeground(EsquemaVisual.corLetraTipoItem);
        this.panelLeft.add(this.labelPanel);
        this.labelNumberOfAnswers = new JLabel();
        this.labelNumberOfAnswers.setForeground(EsquemaVisual.corLetraRotulo);
        this.panelLeft.add("West", this.labelNumberOfAnswers);
        this.setBackground(EsquemaVisual.corAreaDesenho);
    }

    protected boolean validacaoOk(JTextField jTextField, boolean bl) {
        String string = this.removeEspacos(jTextField.getText());
        string = string.replace(',', '.');
        jTextField.setText(string);
        if (string.length() == 0) {
            String[] stringArray = new String[]{"" + this.numQuest};
            String string2 = ResourceReader.msgComVar("exercRNerrNN", "OBJ", stringArray);
            this.janelaExercicio.setMessage(string2);
            AttentionToolTip.showToolTipText(jTextField, string2);
            this.indicaCampoComErro(jTextField);
            this.enviaMensagemErro(ResourceReader.msg("exercRAErroCampoResp"));
            return false;
        }
        if (Analisa.temParametro(string)) {
            String[] stringArray = new String[]{"" + this.numQuest};
            String string3 = ResourceReader.msg("exercRAErroAnimNao");
            this.janelaExercicio.setMessage(string3);
            AttentionToolTip.showToolTipText(jTextField, string3);
            this.indicaCampoComErro(jTextField);
            this.enviaMensagemErro(string3);
            return false;
        }
        if (Analisa.temParametro(string)) {
            String[] stringArray = new String[]{"" + this.numQuest};
            String string4 = ResourceReader.msgComVar("exercRNerrNN", "OBJ", stringArray);
            this.janelaExercicio.setMessage(string4);
            AttentionToolTip.showToolTipText(jTextField, string4);
            this.indicaCampoComErro(jTextField);
            this.enviaMensagemErro(string4);
            System.err.println(IGraf.debugErrorMsg("src/igraf/moduloExercicio/visao/PainelResposta.java: ") + "validacaoOk(...): the number can not have parameters! As in " + string);
            return false;
        }
        if (Analisa.sintaxeCorreta(string)) {
            return true;
        }
        String[] stringArray = new String[]{"" + this.numQuest};
        String string5 = ResourceReader.msgComVar("exercRNerrNN", "OBJ", stringArray);
        this.janelaExercicio.setMessage(string5);
        AttentionToolTip.showToolTipText(jTextField, string5);
        this.indicaCampoComErro(jTextField);
        this.enviaMensagemErro(ResourceReader.msg("exercRAErroExpInv") + string);
        return false;
    }

    protected boolean validacaoOk(JTextField jTextField) {
        Funcao funcao = null;
        String string = this.removeEspacos(jTextField.getText());
        if (string.equals("i") || string.equalsIgnoreCase("infinity") || string.equalsIgnoreCase("infinito")) {
            jTextField.setText(String.valueOf(Double.POSITIVE_INFINITY));
            return true;
        }
        if (string.equals("-i") || string.equalsIgnoreCase("-infinity") || string.equalsIgnoreCase("-infinito")) {
            jTextField.setText(String.valueOf(Double.NEGATIVE_INFINITY));
            return true;
        }
        string = string.replace(',', '.');
        try {
            funcao = new Funcao(1);
            funcao.constroiExpressao(string);
            jTextField.setText(String.valueOf(funcao.f(0.0)));
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    protected boolean temVariavelX(String string, String string2) {
        return !(string.indexOf(120) < 0 & string2.indexOf(120) < 0);
    }

    protected boolean erroAceitavel(double d, double d2) {
        double d3 = Math.abs(d - d2);
        return !(d3 > this.ERROMAX);
    }

    protected void indicaCampoComErro(JTextField jTextField) {
        jTextField.requestFocus();
        jTextField.selectAll();
    }

    protected String removeEspacos(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    protected void enviaMensagemErro(String string) {
        try {
            this.janelaExercicio.setMessage(string);
            System.out.println("PainelResposta.java: " + string);
        }
        catch (Exception exception) {
            System.err.println("Error: there was an error message report <" + string + ">: " + exception);
            exception.printStackTrace();
        }
    }

    protected String respostaCerta(String string) {
        return " Item " + this.numQuest + ". Parab\u00e9ns! A resposta  \"" + string + "\"  est\u00e1 de acordo com o esperado.  ";
    }

    protected String respostaErrada(String string) {
        return " Item " + this.numQuest + ". A resposta  \"" + string + "\"  n\u00e3o est\u00e1 de acordo com o esperado.  ";
    }

    protected float getPrecisao() {
        return this.precisao;
    }

    protected void setLabelText(String string) {
        this.labelPanel.setText(string);
    }

    protected void setPrecisao(float f) {
        this.precisao = f;
    }

    protected void setNumeroResposta(int n) {
        this.numQuest = n;
        this.numResp = "Item:" + String.valueOf(n) + " ";
        this.labelNumberOfAnswers.setText("Item " + String.valueOf(n) + " ");
    }

    protected int getNumResposta() {
        return this.numQuest;
    }

    public String getResposta() {
        return this.numResp;
    }

    protected void adicionaConteudoDireito(JComponent jComponent) {
        this.panelRight.add(jComponent);
    }

    public String getDiagnostico() {
        return this.diagnostico;
    }

    public void resetDiagnostico() {
        this.diagnostico = "";
    }

    protected void registraDiagnostico(String string) {
        this.listaDiagnostico.addElement(string);
    }

    public Vector getListaDiagnostico() {
        return this.listaDiagnostico;
    }

    public int getNumErros() {
        return this.numErros;
    }

    public int getNumAcertos() {
        return this.numAcertos;
    }

    public void reset() {
        this.numAcertos = 0;
        this.numErros = 0;
    }

    public void setNumErros(int n) {
        this.numErros = n;
    }

    public void setValorCorrecao(String string) {
        this.valorCorrecao = string;
    }

    public void setValorResposta(String string) {
        this.valorResposta = string;
    }

    public String getValorCorrecao() {
        return this.valorCorrecao;
    }

    public String getValorResposta() {
        return this.valorResposta;
    }

    protected String correcao() {
        if (this.numErros == 0) {
            return this.acertoTotal;
        }
        if (this.numErros == this.maxNumError) {
            return this.semAcertos;
        }
        return this.acertoParcial;
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 25);
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public void updateLabels() {
        this.semAcertos = ResourceReader.msg("tentNaoCert");
        this.acertoTotal = ResourceReader.msg("tentTotCert");
        this.acertoParcial = ResourceReader.msg("tentParCert");
    }
}

