/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.util.StringTokenizer;

public abstract class Desenho
implements Comparable {
    private static int id = 65;
    private static String prefix = "";
    public boolean ok = false;
    private static final Color laranja = EsquemaVisual.COLOR_laranja;
    private static final Color roxo = EsquemaVisual.COLOR_roxo;
    private static final Color bordo = EsquemaVisual.COLOR_bordo;
    private static final Color marinho = EsquemaVisual.COLOR_marinho;
    private static final Color marrom = EsquemaVisual.COLOR_marrom;
    protected Color corAtual;
    protected static final Color[] colorList = new Color[]{Color.blue, Color.black, marinho, Color.red, laranja, roxo, Color.darkGray, bordo, marrom};
    protected static final String[] colorNames = new String[]{"azul", "preto", "marinho", "vermelho", "laranja", "roxo", "cinza-escuro", "azul-claro", "marrom"};
    private int colorIndex;
    private int ordem;
    protected Polygon polygonToBeDrawn;
    protected Plotter plotter;
    private String comentario;
    private String descricao = "";
    private int stroke = 1;
    private final int eps = 3;

    protected static String getNewId() {
        if (id == 91) {
            id = 65;
            prefix = prefix + "F";
            return prefix + 'A';
        }
        return prefix + (char)id++;
    }

    public Desenho(Plotter plotter, int n) {
        this.setColorIndex(n);
        this.plotter = plotter;
        this.setOrdem(n);
        this.polygonToBeDrawn = new Polygon();
    }

    private void setOrdem(int n) {
        this.ordem = n;
    }

    public int getOrdem() {
        return this.ordem;
    }

    void setComments(String string) {
        this.comentario = string;
    }

    public String getComment() {
        return this.comentario;
    }

    protected int getXMax() {
        return this.plotter.getXMax();
    }

    protected int getXMin() {
        return this.plotter.getXMin();
    }

    protected int getEscala() {
        return this.plotter.getEscala();
    }

    public abstract void atualizaDesenho(Graphics2D var1);

    protected void renderiza(Polygon polygon, Graphics2D graphics2D) {
        graphics2D.setColor(Desenho.getColor(this.colorIndex));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(this.stroke));
        int n = polygon.xpoints[0];
        int n2 = polygon.ypoints[0];
        for (int i = 1; i < polygon.npoints; ++i) {
            int n3 = polygon.xpoints[i];
            int n4 = polygon.ypoints[i];
            if (Math.abs(n4 - n2) < 1000) {
                try {
                    int n5 = this.plotter.normalizaX(n);
                    int n6 = this.plotter.normalizaY(-n2);
                    int n7 = this.plotter.normalizaX(n3);
                    int n8 = this.plotter.normalizaY(-n4);
                    graphics2D.drawLine(n5, n6, n7, n8);
                }
                catch (Exception exception) {
                    System.err.println("Desenho.java: renderiza: i=" + i + ": " + exception.toString());
                }
            } else {
                return;
            }
            n = n3;
            n2 = n4;
        }
        this.stroke = 1;
    }

    public void setColor(Color color) {
        try {
            this.setColorIndex(Desenho.getColorIndex(color));
        }
        catch (Exception exception) {
            this.corAtual = color;
        }
    }

    public Color getColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "rgb:");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken().trim());
            n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new Color(n, n2, n3);
    }

    public void setColorIndex(int n) {
        this.colorIndex = n % colorList.length;
        this.corAtual = colorList[this.colorIndex];
    }

    public Color getColor() {
        return this.corAtual;
    }

    public String getColorToStringRGB(Color color) {
        return "r:" + color.getRed() + " " + "g:" + color.getGreen() + " " + "b:" + color.getBlue();
    }

    public static Color getColor(int n) {
        return colorList[n];
    }

    public static String[] getColorNames() {
        String[] stringArray = new String[]{ResourceReader.msg("AZUL"), ResourceReader.msg("PRETO"), ResourceReader.msg("MARINHO"), ResourceReader.msg("VERMELHO"), ResourceReader.msg("LARANJA"), ResourceReader.msg("ROXO"), ResourceReader.msg("CINZA_ESCURO"), ResourceReader.msg("BORDO"), ResourceReader.msg("MARROM")};
        return stringArray;
    }

    public Polygon getPolygon() {
        return this.polygonToBeDrawn;
    }

    public void setPolygon(Polygon polygon) {
        if (polygon == null) {
            System.err.println("\nError: tentando atribuir poligono vazio a " + id);
            return;
        }
        this.polygonToBeDrawn = polygon;
    }

    public static int getColorIndex(Color color) {
        for (int i = 0; i < colorList.length; ++i) {
            if (!Desenho.coresIguais(color, colorList[i])) continue;
            return i;
        }
        return -1;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    private static boolean coresIguais(Color color, Color color2) {
        return color.getRed() == color2.getRed() && color.getGreen() == color2.getGreen() && color.getBlue() == color2.getBlue();
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String string) {
        this.descricao = string;
    }

    public boolean matchCoordinates(int n, int n2) {
        try {
            Polygon polygon = this.polygonToBeDrawn;
            for (int i = 0; i < polygon.npoints; ++i) {
                if (polygon.xpoints[i] >= n + 3 || polygon.xpoints[i] <= n - 3 || polygon.ypoints[i] >= n2 + 3 || polygon.ypoints[i] <= n2 - 3) continue;
                this.stroke = 2;
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println("Error: in drawing, do not match coordinates(" + n + "," + n2 + "): " + id + ": " + exception);
        }
        return false;
    }

    public abstract String getFuncaoAtual();

    public void insereVertice(float f, float f2) {
    }

    public void setDominio(String string) {
    }

    public int compareTo(Object object) {
        Desenho desenho = (Desenho)object;
        return this.getOrdem() - desenho.getOrdem();
    }
}

