/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.menu;

import difusor.CommunicationFacade;
import difusor.evento.CommunicationEvent;
import igraf.basico.event.ChangeLanguageEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.controle.menu.IgrafMenuController;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloCentral.visao.menu.IgrafMenu;
import igraf.moduloCentral.visao.menu.MenuGrafico;
import igraf.moduloExercicio.visao.menuSelector.DisableMenuEvent;

public class IgrafMenuGraficoController
extends IgrafMenuController {
    private IgrafMenuGraficoEvent igrafMenuGraficoEvent;
    private MenuGrafico menuGrafico;
    private boolean temAnimacao;
    private boolean temAnimacaoOculta;
    private boolean temFuncao;
    private boolean temFuncaoOculta;
    private boolean temPoligono;
    private boolean temPoligonoOculto;

    public IgrafMenuGraficoController(CommunicationFacade communicationFacade, boolean bl, int n) {
        super(communicationFacade, bl, n);
        this.menuGrafico = new MenuGrafico(this, n);
    }

    public IgrafMenu getMenu() {
        return this.menuGrafico;
    }

    public void enviarEventoAcao(String string) {
        this.igrafMenuGraficoEvent = new IgrafMenuGraficoEvent(this, string);
        this.enviarEvento(this.igrafMenuGraficoEvent);
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        if (communicationEvent instanceof DisableMenuEvent) {
            this.removeDisabledMenuItens(communicationEvent);
            return;
        }
        if (communicationEvent instanceof ChangeLanguageEvent) {
            this.menuGrafico.updateLabels();
            return;
        }
        if (communicationEvent instanceof IgrafTabUpdateEvent) {
            IgrafTabUpdateEvent igrafTabUpdateEvent = (IgrafTabUpdateEvent)communicationEvent;
            if (!igrafTabUpdateEvent.getCommand().equals("changeFunctionList") & !igrafTabUpdateEvent.getCommand().equals("changeAnimationList") & !igrafTabUpdateEvent.getCommand().equals("changePolygonList")) {
                return;
            }
            if (igrafTabUpdateEvent.getCommand().equals("changeFunctionList")) {
                this.temFuncao = igrafTabUpdateEvent.getFunctionList().size() > 0;
                this.temFuncaoOculta = igrafTabUpdateEvent.temDesenhoOculto();
            }
            if (igrafTabUpdateEvent.getCommand().equals("changeAnimationList")) {
                this.temAnimacao = igrafTabUpdateEvent.getAnimationList().size() > 0;
                this.temAnimacaoOculta = igrafTabUpdateEvent.temDesenhoOculto();
            }
            if (igrafTabUpdateEvent.getCommand().equals("changePolygonList")) {
                this.temPoligono = igrafTabUpdateEvent.getPolygonList().size() > 0;
                this.temPoligonoOculto = igrafTabUpdateEvent.temDesenhoOculto();
            }
            this.menuGrafico.setEnableAllMenuItem(this.temFuncao | this.temAnimacao | this.temPoligono);
            this.menuGrafico.setEnabledMenuItem(ResourceReader.msg("msgMenuGrfRemoverAba"), true);
            this.menuGrafico.setEnabledMenuItem(ResourceReader.msg("msgMenuGrfNovaSes"), true);
            this.menuGrafico.setEnabledMenuItem(ResourceReader.msg("msgMenuGrfDesTodos"), this.temFuncaoOculta | this.temAnimacaoOculta | this.temPoligonoOculto);
            return;
        }
        if (communicationEvent.getCommand().equals(ResourceReader.msg("msgMenuGrfNovaSes"))) {
            this.menuGrafico.setEnableAllMenuItem(false);
        }
    }

    private void removeDisabledMenuItens(CommunicationEvent communicationEvent) {
        DisableMenuEvent disableMenuEvent = (DisableMenuEvent)communicationEvent;
        int[] nArray = disableMenuEvent.getDisableList();
        int n = nArray == null ? 0 : nArray.length;
        int n2 = 0;
        try {
            while (n2 < n && nArray[n2] < 199) {
                switch (nArray[n2++]) {
                    case 100: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfDes");
                        break;
                    }
                    case 101: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfDesTodos");
                        break;
                    }
                    case 102: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfEditaExp");
                        break;
                    }
                    case 103: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfExibeListaExp");
                        break;
                    }
                    case 104: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfEsconder");
                        break;
                    }
                    case 105: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfEsconderUlt");
                        break;
                    }
                    case 106: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfEsconderTodos");
                        break;
                    }
                    case 107: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfRemoverGrafico");
                        break;
                    }
                    case 108: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfRemoverTodos");
                        break;
                    }
                    case 109: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfNovaAba");
                        break;
                    }
                    case 110: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfRemoverAba");
                        break;
                    }
                    case 111: {
                        this.menuGrafico.removeMenuItem("msgMenuGrfNovaSes");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error: in 'igraf/moduloCentral/controle/menu/IgrafMenuGraficoController.java' with i=" + n2 + ": " + exception.toString());
            exception.printStackTrace();
        }
    }
}

