/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle;

import difusor.CommunicationFacade;
import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.eventos.EventoRegistravel;
import igraf.moduloCentral.eventos.DesenhoTextoEvent;
import igraf.moduloCentral.eventos.EstadoTelaEvent;
import igraf.moduloCentral.eventos.IgrafSessaoEvent;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.eventos.ResetEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuAnimacaoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuCalculoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuEdicaoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloCentral.modelo.EstadoIgraf;
import igraf.moduloCentral.modelo.Sessao;
import igraf.moduloCentral.visao.AreaDesenho;
import igraf.moduloJanelasAuxiliares.eventos.EdicaoExpressaoEvent;
import igraf.moduloJanelasAuxiliares.eventos.JanelaIntegralEvent;
import igraf.moduloJanelasAuxiliares.eventos.JanelaTangenteEvent;
import igraf.moduloSuperior.eventos.EntradaExpressaoEvent;

public class AreaDesenhoController
extends CommunicationController {
    private AreaDesenho areaDDesenho;
    private EstadoIgraf ea = new EstadoIgraf();
    private Sessao sessao;
    private boolean isActive = true;
    private int tabIndex;
    private static int count = 0;
    public final int ID = count++;

    public AreaDesenhoController(CommunicationFacade communicationFacade, boolean bl, int n) {
        super(communicationFacade, bl);
        this.sessao = new Sessao(n);
        this.tabIndex = n;
    }

    public AreaDesenho getAreaDesenho() {
        return this.areaDDesenho;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public void setControlledObject(Object object) {
        this.areaDDesenho = (AreaDesenho)object;
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        String string = "";
        String string2 = communicationEvent.getCommand();
        if (!this.isActive) {
            return;
        }
        if (string2.equals("clear screen")) {
            this.areaDDesenho.limpaRastro();
        } else if (string2.equals("update")) {
            this.areaDDesenho.graphPlotter.trataMenuAnimacao(communicationEvent);
        } else if (communicationEvent instanceof IgrafMenuAnimacaoEvent) {
            if (string2.equals(ResourceReader.msg("maRastro"))) {
                this.areaDDesenho.mudaEstadoRastro();
            } else {
                this.areaDDesenho.graphPlotter.trataMenuAnimacao(communicationEvent);
            }
        } else if (string2.equals("get limits")) {
            this.areaDDesenho.graphPlotter.reportLimits();
        } else if (communicationEvent instanceof ResetEvent) {
            this.areaDDesenho.graphPlotter.resetPlotter();
            this.areaDDesenho.polygonPlotter.resetPlotter();
            this.areaDDesenho.eixos.resetPlotter();
            this.sessao.reset();
            string = "";
        } else if (communicationEvent instanceof IgrafTabUpdateEvent) {
            IgrafTabUpdateEvent igrafTabUpdateEvent = (IgrafTabUpdateEvent)communicationEvent;
            if (!igrafTabUpdateEvent.getCommand().equals("general update")) {
                this.ea.atualizaEstadoIgraf(igrafTabUpdateEvent);
            }
            if (igrafTabUpdateEvent.getCommand().equals("changeSliderValue")) {
                this.areaDDesenho.graphPlotter.trataMenuAnimacao(communicationEvent);
            }
        } else if (communicationEvent instanceof EntradaExpressaoEvent) {
            EntradaExpressaoEvent entradaExpressaoEvent = (EntradaExpressaoEvent)communicationEvent;
            if (entradaExpressaoEvent.getCommand().equals("draw_polygon")) {
                this.areaDDesenho.polygonPlotter.inserePoligono(entradaExpressaoEvent);
            } else if (!string.equals(entradaExpressaoEvent.getExpressao())) {
                this.areaDDesenho.graphPlotter.insereDesenho(entradaExpressaoEvent.getExpressao(), "", entradaExpressaoEvent.getDominio());
                string = entradaExpressaoEvent.getExpressao();
            }
        } else if (communicationEvent instanceof EdicaoExpressaoEvent) {
            this.areaDDesenho.graphPlotter.editaFuncaoTela((EdicaoExpressaoEvent)communicationEvent);
        } else if (communicationEvent instanceof EstadoTelaEvent) {
            this.areaDDesenho.graphPlotter.mudaEstadoTela((EstadoTelaEvent)communicationEvent);
            this.areaDDesenho.eixos.mudaEstadoTela((EstadoTelaEvent)communicationEvent);
        } else if (communicationEvent instanceof DesenhoTextoEvent) {
            this.areaDDesenho.graphPlotter.trataDesenhoTexto(communicationEvent);
        } else if (communicationEvent instanceof IgrafMenuEdicaoEvent) {
            this.areaDDesenho.graphPlotter.trataMenuEdicaoEvent(communicationEvent);
            this.areaDDesenho.eixos.trataMenuEdicaoEvent(communicationEvent);
        } else if (communicationEvent instanceof IgrafMenuGraficoEvent) {
            this.areaDDesenho.graphPlotter.trataMenuGraficoEvent((IgrafMenuGraficoEvent)communicationEvent);
            this.areaDDesenho.polygonPlotter.trataMenuGraficoEvent(communicationEvent);
        } else if (communicationEvent instanceof IgrafMenuCalculoEvent) {
            this.areaDDesenho.graphPlotter.trataCalculoEvent((IgrafMenuCalculoEvent)communicationEvent);
        } else if (communicationEvent instanceof JanelaIntegralEvent) {
            this.areaDDesenho.graphPlotter.trataCalculoEvent((JanelaIntegralEvent)communicationEvent);
            if (string2.equals("eraseArea")) {
                return;
            }
        } else if (communicationEvent instanceof JanelaTangenteEvent) {
            JanelaTangenteEvent janelaTangenteEvent = (JanelaTangenteEvent)communicationEvent;
            this.areaDDesenho.graphPlotter.trataDesenhoTangente(janelaTangenteEvent);
            if (janelaTangenteEvent.getCommand().equals("animTangent")) {
                this.iniciaAnimacao(janelaTangenteEvent.getAnimationMode());
            }
        }
        this.areaDDesenho.atualizaDesenho();
        if (communicationEvent instanceof EventoRegistravel) {
            this.registraEvento(communicationEvent);
        }
    }

    private void enviarSessao() {
        this.enviarEvento(new IgrafSessaoEvent((Object)this, this.sessao));
    }

    public void registraEvento(CommunicationEvent communicationEvent) {
        if (this.sessao.registraEvento(communicationEvent)) {
            this.enviarSessao();
        }
    }

    public void notificaTrocaAba() {
        IgrafTabUpdateEvent igrafTabUpdateEvent = new IgrafTabUpdateEvent(this, "general update");
        igrafTabUpdateEvent.setExpression(this.ea.getConteudoEntradaExpressao());
        igrafTabUpdateEvent.setExercise(this.sessao.isItExercise());
        igrafTabUpdateEvent.setSliderValue(this.ea.getValorSlider());
        this.areaDDesenho.graphPlotter.notificaAlteracaoEstado();
        this.areaDDesenho.graphPlotter.notifyScreenChanged();
        this.enviarEvento(igrafTabUpdateEvent);
    }

    public void iniciaAnimacao(boolean bl) {
        this.areaDDesenho.animar(bl);
    }
}

