/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloArquivo.controle;

import difusor.CommunicationFacade;
import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.IGraf;
import igraf.IgrafClosingEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.Arquivo;
import igraf.moduloArquivo.eventos.LoadingIGrafEvent;
import igraf.moduloArquivo.modelo.ArquivoModel;
import igraf.moduloCentral.eventos.IgrafSessaoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloExercicio.eventos.DiagnosticEvent;

public class ArquivoController
extends CommunicationController {
    public static final String IGCLASSPATH = "igraf/moduloArquivo/controle/ArquivoController.java: ";
    private Arquivo arq = new Arquivo(this);
    private static ArquivoModel arquivoModel;

    public ArquivoController(CommunicationFacade communicationFacade, boolean bl) {
        super(communicationFacade, bl);
        arquivoModel = this.arq.getModel();
        arquivoModel.setController(this);
    }

    public static String getSessao() {
        return arquivoModel.getListaSessaoAsString();
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        String string = communicationEvent.getCommand();
        if (string.equals("send result")) {
            this.enviarEvento(new DiagnosticEvent(this, arquivoModel.getListaSessaoAsString()));
            return;
        }
        if (communicationEvent instanceof IgrafClosingEvent) {
            if (this.solicitaGravacao()) {
                System.exit(0);
            }
        } else if (communicationEvent instanceof LoadingIGrafEvent) {
            LoadingIGrafEvent loadingIGrafEvent = (LoadingIGrafEvent)communicationEvent;
            if (loadingIGrafEvent.getDados() != null) {
                arquivoModel.refazSessao(loadingIGrafEvent.getDados());
            }
        } else if (string.equals("redraw all")) {
            arquivoModel.restabelerSessao();
        } else if (string.equals("step redraw")) {
            arquivoModel.proximaAcao();
        } else if (string.equals(ResourceReader.msg("arqMenuNovo"))) {
            if (this.solicitaGravacao()) {
                IgrafMenuGraficoEvent igrafMenuGraficoEvent = new IgrafMenuGraficoEvent(this, ResourceReader.msg("msgMenuGrfNovaSes"));
                this.enviarEvento(igrafMenuGraficoEvent);
                this.resetArquivo();
            }
        } else if (string.equals(ResourceReader.msg("arqMenuAbra"))) {
            if (this.solicitaGravacao()) {
                this.arq.loadFile();
            }
        } else if (string.equals(ResourceReader.msg("arqMenuGrave"))) {
            arquivoModel.sessionChanged(!this.arq.gravarGrafico());
        } else if (string.equals(ResourceReader.msg("arqMenuComo"))) {
            arquivoModel.sessionChanged(!this.arq.gravarComo("arquivo"));
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error? This option is supossed to be disabled! " + ResourceReader.msg("arqMenuComo"));
        } else if (string.equals(ResourceReader.msg("arqMenuHTML"))) {
            this.arq.gerarHTML();
        } else if (string.equals(ResourceReader.msg("arqMenuExerc"))) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error? This option is supossed to be disabled! arqMenuExerc=" + ResourceReader.msg("arqMenuExerc"));
        } else if (!string.equals(ResourceReader.msg("arqMenuImprima"))) {
            if (string.equals("review session data")) {
                arquivoModel.carregarListaAcao();
            } else if (string.equals("update session data")) {
                IgrafSessaoEvent igrafSessaoEvent = (IgrafSessaoEvent)communicationEvent;
                arquivoModel.insereSessao(igrafSessaoEvent.getSessao());
            }
        }
    }

    private boolean solicitaGravacao() {
        if (arquivoModel.sessionChanged()) {
            int n = this.arq.desejaGravarAlteracao();
            if (n == 2) {
                return false;
            }
            if (n == 0 && !this.arq.gravarGrafico()) {
                return false;
            }
        }
        return true;
    }

    private void resetArquivo() {
        this.arq.reset();
        arquivoModel.reset();
    }
}

