/*
 * Decompiled with CFR 0.152.
 */
package igraf.basico.util;

import igraf.IGraf;
import igraf.basico.util.Funcao;
import java.awt.Polygon;

public class GeraPoligono {
    public static final String IGCLASSPATH = "igraf/basico/util/GeraPoligono.java";
    static int start;
    static int end;
    static int cte;
    static int num;
    static Funcao fnc;
    static Polygon polygonToDraw;
    static double y;
    static String funcaoDerivada;
    private static boolean onePrint;
    static int contS;
    static int contS2;
    private static int contErrFx;

    public static Polygon getGrafico(String string, int n, int n2, double d) {
        if (string == null || string == "") {
            return null;
        }
        GeraPoligono.preparacao(string);
        for (int i = n; i < n2; ++i) {
            try {
                y = -fnc.f((double)i / d);
                if (Double.isNaN(y)) continue;
                GeraPoligono.addPoint(i, y * d);
                continue;
            }
            catch (Exception exception) {
                if (onePrint) continue;
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + ": Error: in polygon definition: func='" + string + "', fnc='" + fnc + "', " + funcaoDerivada);
                exception.printStackTrace();
                onePrint = true;
            }
        }
        return polygonToDraw;
    }

    private static void setFuncaoDerivada(String string) {
        funcaoDerivada = string;
    }

    public static String getFuncaoDerivada() {
        return funcaoDerivada;
    }

    public static String getDerivada(String string) {
        GeraPoligono.preparacao(string);
        fnc.derivaFuncao((byte)1);
        GeraPoligono.setFuncaoDerivada(fnc.toStringDerivada());
        return GeraPoligono.getFuncaoDerivada();
    }

    public static Polygon getGraficoAntiDerivada(String string, int n, int n2, double d) {
        boolean bl = false;
        int n3 = 0;
        GeraPoligono.preparacao(string);
        double d2 = 1.0;
        for (int i = n; i < n2; ++i) {
            double d3 = 0.0;
            int n4 = 0;
            for (int j = n; j < i; ++j) {
                d3 += -fnc.f((double)j / d);
                ++n4;
            }
            if (Double.isNaN(y)) continue;
            if (i == 0) {
                n3 = new Double(d3).intValue();
            }
            GeraPoligono.addPoint(i, (double)(i - n) * d3 / (double)n4 * d2);
        }
        polygonToDraw.translate(0, -n3);
        return polygonToDraw;
    }

    private static void preparacao(String string) {
        y = 0.0;
        try {
            if (!fnc.constroiExpressao(string)) {
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("Erro: em interpolar funcao: " + string + ": " + exception);
            return;
        }
        polygonToDraw = new Polygon();
    }

    private static void addPoint(int n, double d) {
        if (polygonToDraw == null) {
            if (contErrFx++ < 2) {
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: in add point (" + n + "," + d + ") at polygon!");
            }
            return;
        }
        polygonToDraw.addPoint(n, new Double(d).intValue());
    }

    static {
        num = 0;
        fnc = new Funcao(2);
        onePrint = false;
        contS = 0;
        contS2 = 0;
        contErrFx = 0;
    }
}

