/*
 * Decompiled with CFR 0.152.
 */
package igraf.basico.util;

import igraf.IGraf;
import igraf.edu.hws.jcm.data.Expression;
import igraf.edu.hws.jcm.data.ParseError;
import igraf.edu.hws.jcm.data.Parser;
import igraf.edu.hws.jcm.data.Variable;

public class Funcao
implements Cloneable {
    public static final String IGCLASSPATH = "igraf/basico/util/Funcao.java";
    private String funcao;
    private Expression expr;
    private Expression exprDerivada;
    private Variable x;
    private Variable y;
    private Parser parser = new Parser(1026);
    private static int contErrFx = 0;

    public Funcao(int n) {
        this.parser.remove("trunc");
        this.parser.remove("round");
        this.x = new Variable("x");
        this.y = new Variable("y");
        this.parser.add(this.x);
        if (n == 2) {
            this.parser.add(this.y);
        }
    }

    public int getNumVar() {
        return this.parser.get("y") == null ? 1 : 2;
    }

    public boolean constroiExpressao(String string) {
        this.funcao = string;
        try {
            this.expr = this.parser.parse(this.funcao);
        }
        catch (ParseError parseError) {
            return false;
        }
        return true;
    }

    public double f(double d) {
        this.x.setVal(d);
        if (this.expr != null) {
            return this.expr.getVal();
        }
        if (contErrFx++ < 2) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: in expression evaluation at point " + d + ": " + this.expr);
        }
        return d;
    }

    public double f(double d, double d2) {
        if (this.parser.get("y") == null) {
            System.out.println("Problems, not working with 2 vars");
            return -1.0;
        }
        this.x.setVal(d);
        this.y.setVal(d2);
        return this.expr.getVal();
    }

    public void derivaFuncao(byte by) {
        this.exprDerivada = this.expr.derivative(this.x);
        if (by == 2) {
            this.exprDerivada = this.exprDerivada.derivative(this.x);
        }
    }

    public double fD(double d) {
        this.x.setVal(d);
        return this.exprDerivada.getVal();
    }

    public String toStringFuncao() {
        return String.valueOf(this.expr);
    }

    public String toStringDerivada() {
        return String.valueOf(this.exprDerivada);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

