/*
 * Decompiled with CFR 0.152.
 */
package igraf.basico.event;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class AttentionToolTip {
    private static final Color COLORBACK = new Color(220, 230, 250);
    private static final Font FONT = new Font("Helvetica", 0, 11);
    private static Timer timer;
    private static final long delay = 500L;
    private static final long DELAY = 5000L;
    private static int counter;
    private static String msgText;
    private JWindow attentionWindow;
    private JPanel contentPane;

    protected void sendTimedEvent(TimerTask timerTask) {
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer();
        timer.schedule(timerTask, 0L, 500L);
        counter = 0;
    }

    protected void showMsgForAwhile() {
        this.attentionWindow.setVisible(true);
        this.sendTimedEvent(new SendEventTask());
        System.out.println("igraf/basico/event/AttentionToolTip.java: showMsgForAwhile(): " + this.attentionWindow.getClass().getName());
    }

    public static void setToolTipText(String string) {
        msgText = string;
    }

    public static void showToolTipText(Component component, String string) {
        AttentionToolTip attentionToolTip = new AttentionToolTip();
        attentionToolTip.showToolTipTextTimer(component, string);
    }

    private void showToolTipTextTimer(Component component, String string) {
        JLabel jLabel = new JLabel(string);
        Window window = SwingUtilities.getWindowAncestor(component);
        jLabel.setOpaque(true);
        jLabel.setFont(FONT);
        jLabel.setBackground(COLORBACK);
        this.attentionWindow = new JWindow(window);
        this.contentPane = (JPanel)this.attentionWindow.getContentPane();
        this.contentPane.add(jLabel);
        this.contentPane.setBackground(COLORBACK);
        this.contentPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.attentionWindow.pack();
        Point point = component.getLocationOnScreen();
        this.attentionWindow.setLocation(point.x + 20, point.y + 30);
        this.showMsgForAwhile();
    }

    static {
        counter = 0;
        msgText = "";
    }

    class SendEventTask
    extends TimerTask {
        SendEventTask() {
        }

        public void run() {
            counter++;
            if (counter > 4) {
                try {
                    AttentionToolTip.this.attentionWindow.setVisible(false);
                    timer.cancel();
                    AttentionToolTip.timer = null;
                    return;
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("AttentionToolTip.java: " + runtimeException);
                    timer.cancel();
                    AttentionToolTip.timer = null;
                }
            }
        }
    }
}

