/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloSuperior.visao;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.io.TrataImagem;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloSuperior.controle.MenuArquivoController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuFile
extends JPopupMenu
implements LanguageUpdatable {
    public static final int WIDTHMENUFILE = 100;
    private static final String IMG = "basico/img/button_file_bg.gif";
    private final ImageIcon icon = MenuFile.getBGimage();
    private static final Color corFundoMenuTopo = EsquemaVisual.corFundo;
    private static final Color corFundoPS = EsquemaVisual.corBackground;
    private JLabel menuLabel;
    private JMenuItem menuItemNew = new JMenuItem(ResourceReader.msg("arqMenuNovo"));
    private JMenuItem menuItemOpen = new JMenuItem(ResourceReader.msg("arqMenuAbra"));
    private JMenuItem menuItemRegister = new JMenuItem(ResourceReader.msg("arqMenuGrave"));
    private JMenuItem menuItemCopy = new JMenuItem(ResourceReader.msg("arqMenuCopia"));
    private JMenuItem menuItemExport = new JMenuItem(ResourceReader.msg("arqMenuExporta"));
    private JMenuItem menuItemHTML = new JMenuItem(ResourceReader.msg("arqMenuHTML"));
    private JMenuItem menuItemPrint = new JMenuItem(ResourceReader.msg("arqMenuImprima"));
    private JMenuItem menuItemQuit = new JMenuItem(ResourceReader.msg("arqMenuSaia"));

    private static ImageIcon getBGimage() {
        try {
            return TrataImagem.getImageIcon(IMG);
        }
        catch (Exception exception) {
            System.err.println("Erro: ao tentar abrir imagem basico/img/button_file_bg.gif: " + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public MenuFile(String string, MenuArquivoController menuArquivoController, int n) {
        this.menuLabel = new JLabel(string, 0){

            public void paintComponent(Graphics graphics) {
                graphics.drawImage(MenuFile.this.icon.getImage(), 0, 0, null);
                super.paintComponent(graphics);
            }
        };
        this.menuLabel.addMouseListener(menuArquivoController);
        this.menuLabel.setOpaque(false);
        this.menuLabel.setForeground(EsquemaVisual.corLetras);
        this.menuLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.menuLabel.setPreferredSize(new Dimension(100, n));
        this.buildPopupMenu(menuArquivoController);
        menuArquivoController.setMenu(this);
    }

    private void buildJMenuItem(JMenuItem jMenuItem, MenuArquivoController menuArquivoController) {
        jMenuItem.setBackground(corFundoPS);
        jMenuItem.addActionListener(menuArquivoController);
        this.add(jMenuItem);
    }

    private void buildPopupMenu(MenuArquivoController menuArquivoController) {
        this.buildJMenuItem(this.menuItemNew, menuArquivoController);
        this.buildJMenuItem(this.menuItemOpen, menuArquivoController);
        this.addSeparator();
        this.buildJMenuItem(this.menuItemRegister, menuArquivoController);
        this.addSeparator();
        this.buildJMenuItem(this.menuItemCopy, menuArquivoController);
        this.buildJMenuItem(this.menuItemExport, menuArquivoController);
        this.addSeparator();
        this.buildJMenuItem(this.menuItemHTML, menuArquivoController);
        this.buildJMenuItem(this.menuItemPrint, menuArquivoController);
        this.addSeparator();
        this.buildJMenuItem(this.menuItemQuit, menuArquivoController);
    }

    public JLabel getMenuFileLabel() {
        return this.menuLabel;
    }

    public void updateLabels() {
        this.menuLabel.setText(ResourceReader.msg("arquivo"));
        this.menuItemRegister.setText(ResourceReader.msg("arqMenuGrave"));
        this.menuItemNew.setText(ResourceReader.msg("arqMenuNovo"));
        this.menuItemOpen.setText(ResourceReader.msg("arqMenuAbra"));
        this.menuItemHTML.setText(ResourceReader.msg("arqMenuHTML"));
        this.menuItemPrint.setText(ResourceReader.msg("arqMenuImprima"));
        this.menuItemCopy.setText(ResourceReader.msg("arqMenuCopia"));
        this.menuItemExport.setText(ResourceReader.msg("arqMenuExporta"));
        this.menuItemQuit.setText(ResourceReader.msg("arqMenuSaia"));
    }
}

