/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao.integral;

import igraf.basico.io.ResourceReader;
import igraf.basico.util.Calculo;
import igraf.basico.util.Utilitarios;
import igraf.moduloJanelasAuxiliares.visao.integral.PainelIntegral;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PainelOpcoesIntegracao
extends Panel
implements ItemListener,
ActionListener {
    private Checkbox colorModeCB;
    private Checkbox areaCB;
    private Checkbox integralCB;
    private CheckboxGroup cbg;
    private Color corLetra = Color.blue;
    private Color corPositiva = new Color(180, 100, 255);
    private Color corNegativa = new Color(255, 100, 180);
    private Label label03;
    private Label label01;
    private Label label02;
    private Button buttonIntegrates;
    private Dimension dimension = new Dimension(192, 180);
    private Panel painelVazio;
    private Panel painelFinal;
    private PainelIntegral painelIntegral;
    private String limiteInf;
    private String limiteSup;
    private String fSuperior;
    private String fInferior;
    private double intSuperior;
    private double intInferior;
    private double de;
    private double a;
    private String[] listOfAvailableFunctions;

    public PainelOpcoesIntegracao(PainelIntegral painelIntegral) {
        this.setBackground(new Color(247, 247, 247));
        this.setLayout(new GridLayout(0, 1, 0, 4));
        this.painelIntegral = painelIntegral;
        this.configuraOpcoes();
        this.configuraResultados();
    }

    private void configuraResultados() {
        Panel panel = new Panel(new GridLayout(0, 1, 0, 0)){

            public void paint(Graphics graphics) {
                graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            }

            public Insets getInsets() {
                return new Insets(4, 6, 3, 4);
            }
        };
        this.buttonIntegrates = new Button(ResourceReader.msg("btInteg"));
        this.label01 = new Label();
        this.label02 = new Label();
        this.label03 = new Label();
        this.label01.setForeground(this.corPositiva);
        this.label03.setForeground(this.corLetra);
        this.buttonIntegrates.addActionListener(this);
        panel.add(this.label01);
        panel.add(this.label02);
        panel.add(this.label03);
        panel.add(this.buttonIntegrates);
        this.add(panel);
    }

    private void configuraOpcoes() {
        Panel panel = new Panel(new GridLayout(0, 1, 0, 0)){

            public void paint(Graphics graphics) {
                graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            }

            public Insets getInsets() {
                return new Insets(4, 6, 2, 4);
            }
        };
        this.cbg = new CheckboxGroup();
        this.colorModeCB = new Checkbox(ResourceReader.msg("colCB"), true);
        this.integralCB = new Checkbox(ResourceReader.msg("intCB"), this.cbg, true);
        this.areaCB = new Checkbox(ResourceReader.msg("areCB"), this.cbg, false);
        this.colorModeCB.setForeground(this.corLetra);
        this.integralCB.setForeground(this.corLetra);
        this.areaCB.setForeground(this.corLetra);
        this.colorModeCB.addItemListener(this);
        this.integralCB.addItemListener(this);
        this.areaCB.addItemListener(this);
        panel.add(this.colorModeCB);
        panel.add(this.integralCB);
        panel.add(this.areaCB);
        this.add(panel);
    }

    public Insets getInsets() {
        return new Insets(3, 2, 2, 4);
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        if (checkbox.equals(this.colorModeCB)) {
            if (this.colorModeCB.getState()) {
                this.painelIntegral.pintaRegiao(this.listOfAvailableFunctions, this.de, this.a, this.areaCB.getState());
            } else {
                this.painelIntegral.limpaRegiao();
            }
        } else {
            if (checkbox.equals(this.areaCB)) {
                this.setLabelArea();
            } else {
                this.setLabelIntegral();
            }
            this.painelIntegral.mudaPinturaRegiao(this.areaCB.getState());
        }
    }

    private void setLabelArea() {
        this.label01.setText("");
        this.label02.setForeground(this.corLetra);
        this.label02.setText("   " + ResourceReader.msg("area") + "    = " + Utilitarios.precisao(this.intSuperior - this.intInferior));
        this.label03.setText("");
    }

    private void setLabelIntegral() {
        this.label01.setText("     A1     = " + Utilitarios.precisao(this.intSuperior));
        this.label02.setForeground(this.corNegativa);
        this.label02.setText("     A2     = " + Utilitarios.precisao(-this.intInferior));
        this.label03.setText("A1 - A2 = " + Utilitarios.precisao(this.intSuperior + this.intInferior));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonIntegrates) {
            this.integrar();
        }
    }

    public void integrar() {
        this.intInferior = 0.0;
        this.intSuperior = 0.0;
        this.listOfAvailableFunctions = this.painelIntegral.getListaFuncoesSelecionadas();
        this.de = this.painelIntegral.getFrom();
        this.a = this.painelIntegral.getTo();
        if (this.listOfAvailableFunctions[0] == null | this.listOfAvailableFunctions[0].length() < 1) {
            return;
        }
        int n = this.listOfAvailableFunctions[0].indexOf(34);
        if (n > -1) {
            this.listOfAvailableFunctions[0] = this.listOfAvailableFunctions[0].substring(0, n);
        }
        Calculo.integralDefinida(this.listOfAvailableFunctions[0], this.de, this.a);
        this.intSuperior += Calculo.getPartePositivaIntegral();
        this.intInferior += Calculo.getParteNegativaIntegral();
        n = this.listOfAvailableFunctions[1].indexOf(34);
        if (n > -1) {
            this.listOfAvailableFunctions[1] = this.listOfAvailableFunctions[1].substring(0, n);
        }
        Calculo.integralDefinida(this.listOfAvailableFunctions[1], this.de, this.a);
        this.intSuperior += Calculo.getPartePositivaIntegral();
        this.intInferior += Calculo.getParteNegativaIntegral();
        if (this.colorModeCB.getState()) {
            boolean bl = this.areaCB.getState();
            this.painelIntegral.pintaRegiao(this.listOfAvailableFunctions, this.de, this.a, bl);
            if (bl) {
                this.setLabelArea();
            } else {
                this.setLabelIntegral();
            }
        }
    }

    public void updateLabels() {
        this.buttonIntegrates.setLabel(ResourceReader.msg("btInteg"));
        this.colorModeCB.setLabel(ResourceReader.msg("colCB"));
        this.integralCB.setLabel(ResourceReader.msg("intCB"));
        this.areaCB.setLabel(ResourceReader.msg("areCB"));
    }
}

