/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.eventos.DesenhoTextoEvent;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloJanelasAuxiliares.controle.JanelaEntradaTextoController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import moduloColor.ColorChangeListener;
import moduloColor.ColorEvent;
import moduloColor.ColorFrame;

public class JanelaEntradaTexto
extends JFrame
implements ItemListener,
LanguageUpdatable,
ColorChangeListener {
    private static final int WIDTHBLOCK = 240;
    private static final int HEIGHTBLOCK = 50;
    private static final Font font = new Font("Arial", 0, 10);
    JPanel southPanel;
    JPanel colunaDois;
    JButton inserir = new JButton(ResourceReader.msg("msgOK"));
    JButton cancelar = new JButton(ResourceReader.msg("msgCancelar"));
    JComboBox colorChoice;
    JComboBox sizeChoice;
    Color cor = Color.blue;
    JTextArea textArea = new JTextArea(5, 80);
    JTextField tf_x;
    JTextField tf_y;
    private int size = 12;
    private String textAreaContent = "";
    private JanelaEntradaTextoController jetc;
    private JLabel labelCol1Position1;
    private JLabel labelCol1Position2;
    private JLabel labelCol2Font;

    public JanelaEntradaTexto(JanelaEntradaTextoController janelaEntradaTextoController) {
        this();
        this.inserir.addActionListener(janelaEntradaTextoController);
        this.cancelar.addActionListener(janelaEntradaTextoController);
        this.textArea.addKeyListener(janelaEntradaTextoController);
        this.jetc = janelaEntradaTextoController;
        this.setFont(font);
        this.setFontColor(this.cor);
    }

    public JanelaEntradaTexto() {
        super(ResourceReader.msg("tiInsTexto"));
        JanelaEntradaTexto.putBorder(false, this.textArea);
        this.textArea.setBackground(EsquemaVisual.corAreaDesenho);
        this.textArea.setForeground(Color.black);
        this.textArea.setFont(font);
        this.textArea.setText("");
        this.configureSouthPanel();
        this.configureColunaUm();
        this.configureColunaDois();
        this.configureColunaTres();
        JanelaEntradaTexto.putBorder(false, this.southPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JanelaEntradaTexto.this.jetc.cancelarEdicao();
            }
        });
        this.getContentPane().add("North", this.textArea);
        this.getContentPane().add("South", this.southPanel);
        this.pack();
    }

    private static void putBorder(boolean bl, JComponent jComponent) {
        if (bl && jComponent instanceof JPanel) {
            ((JPanel)jComponent).setPreferredSize(new Dimension(240, 50));
        }
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
    }

    private void configureSouthPanel() {
        this.southPanel = new JPanel();
        this.southPanel.setBackground(EsquemaVisual.corAreaDesenho);
    }

    private void configureColunaUm() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        JanelaEntradaTexto.putBorder(true, jPanel);
        jPanel.setBackground(EsquemaVisual.corAreaDesenho);
        this.labelCol1Position1 = new JLabel(ResourceReader.msg("tiPosTexto1"));
        this.labelCol1Position2 = new JLabel(ResourceReader.msg("tiPosTexto2"));
        this.labelCol1Position1.setFont(font);
        this.labelCol1Position2.setFont(font);
        jPanel.add(this.labelCol1Position1);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(" x = ");
        jPanel2.setBackground(EsquemaVisual.corAreaDesenho);
        jLabel.setFont(font);
        this.tf_x = new JTextField("0", 6);
        jPanel2.add("West", jLabel);
        jPanel2.add("East", this.tf_x);
        jPanel.add(jPanel2);
        jPanel.add(this.labelCol1Position2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel2 = new JLabel(" y = ");
        jPanel3.setBackground(EsquemaVisual.corAreaDesenho);
        jLabel2.setFont(font);
        this.tf_y = new JTextField("0", 6);
        jPanel3.add("West", jLabel2);
        jPanel3.add("East", this.tf_y);
        jPanel.add(jPanel3);
        this.southPanel.add(jPanel);
    }

    private void configureColunaDois() {
        this.colunaDois = new JPanel(new GridLayout(2, 2));
        this.colunaDois.setBackground(EsquemaVisual.corAreaDesenho);
        JanelaEntradaTexto.putBorder(true, this.colunaDois);
        this.labelCol2Font = new JLabel(ResourceReader.msg("msgFonte"));
        this.labelCol2Font.setFont(font);
        this.configureColorChoice();
        this.configureSizeChoice();
        this.colunaDois.add(this.labelCol2Font);
        this.colunaDois.add(this.colorChoice);
        this.colunaDois.add(new JLabel(""));
        this.colunaDois.add(this.sizeChoice);
        this.southPanel.add(this.colunaDois);
    }

    private void configureSizeChoice() {
        this.sizeChoice = new JComboBox();
        this.sizeChoice.setFont(font);
        this.sizeChoice.addItem("10");
        this.sizeChoice.addItem("12");
        this.sizeChoice.addItem("14");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("18");
        this.sizeChoice.addItem("20");
        this.sizeChoice.addItem(ResourceReader.msg("tiPadrao"));
        this.sizeChoice.addItemListener(this);
    }

    private void configureColorChoice() {
        this.colorChoice = new JComboBox();
        String[] stringArray = Desenho.getColorNames();
        this.colorChoice.setFont(font);
        for (int i = 0; i < stringArray.length; ++i) {
            this.colorChoice.addItem(stringArray[i]);
        }
        this.colorChoice.addItem("----------");
        this.colorChoice.addItem(ResourceReader.msg("tiOutrasCores"));
        this.colorChoice.addItemListener(this);
    }

    private void configureColunaTres() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 3));
        jPanel.add(this.inserir);
        jPanel.add(this.cancelar);
        this.southPanel.add(jPanel);
        this.inserir.setEnabled(false);
        this.cancelar.setBackground(EsquemaVisual.corFundoBotoes);
        this.cancelar.setForeground(EsquemaVisual.corLetrasBotoes);
        this.inserir.setForeground(EsquemaVisual.corLetrasBotoes);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String string) {
        this.textArea.setText(string);
        this.setTextAreaContent(string);
    }

    public void setTextAreaContent(String string) {
        this.textAreaContent = string;
        this.inserir.setLabel(ResourceReader.msg("msgOK"));
        this.inserir.setEnabled(true);
    }

    public Color getFontColor() {
        return Desenho.getColor(this.colorChoice.getSelectedIndex());
    }

    private void setFontColor(Color color) {
        this.cor = color;
        this.textArea.setForeground(this.cor);
    }

    private void setFontSize(int n) {
        this.textArea.setFont(new Font("Arial", 0, n));
        this.size = n;
    }

    public void setChoices(Color color, int n) {
        this.sizeChoice.setSelectedItem(String.valueOf(n));
        this.setFontColor(color);
        this.setFontSize(n);
    }

    public int getFontSize() {
        this.size = Integer.parseInt((String)this.sizeChoice.getSelectedItem());
        return this.size;
    }

    public Font getUserSelectedFont() {
        return new Font("Arial", 0, this.getFontSize());
    }

    public float getTextPositionX() {
        if (this.tf_x == null) {
            return 0.0f;
        }
        return Float.parseFloat(this.tf_x.getText());
    }

    public float getTextPositionY() {
        if (this.tf_y == null) {
            return 0.0f;
        }
        return Float.parseFloat(this.tf_y.getText());
    }

    public void setTextPositionX(float f) {
        this.tf_x.setText(String.valueOf(f));
    }

    public void setTextPositionY(float f) {
        this.tf_y.setText(String.valueOf(f));
    }

    public void habilitaInserir(boolean bl) {
        this.inserir.setEnabled(bl);
        if (bl) {
            this.inserir.setBackground(EsquemaVisual.corFundoBotoes);
        } else {
            this.inserir.setBackground(Color.LIGHT_GRAY);
        }
    }

    public void setData(DesenhoTextoEvent desenhoTextoEvent) {
        this.setChoices(desenhoTextoEvent.getFontColor(), desenhoTextoEvent.getFontSize());
        this.setText(desenhoTextoEvent.getTextoAtual());
        this.setTextPositionX(desenhoTextoEvent.getTextPositionX());
        this.setTextPositionY(desenhoTextoEvent.getTextPositionY());
        this.habilitaInserir(true);
    }

    private void setTextAreaFont(Font font) {
        this.textArea.setFont(font);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (jComboBox.getSelectedItem().equals(ResourceReader.msg("tiOutrasCores"))) {
            new ColorFrame(this);
            return;
        }
        try {
            if (jComboBox == this.colorChoice) {
                this.setFontColor(this.getFontColor());
            }
            if (jComboBox == this.sizeChoice) {
                this.setFontSize(this.getFontSize());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void insereQuebra() {
        this.textAreaContent = this.textAreaContent + "\r\n";
    }

    public void updateLabels() {
        this.setTitle(ResourceReader.msg("tiInsTexto"));
        this.inserir.setLabel(ResourceReader.msg("msgOK"));
        this.cancelar.setLabel(ResourceReader.msg("msgCancelar"));
        this.labelCol1Position1.setText(ResourceReader.msg("tiPosTexto1"));
        this.labelCol1Position2.setText(ResourceReader.msg("tiPosTexto2"));
        this.labelCol2Font.setText(ResourceReader.msg("msgFonte"));
    }

    public void updateColor(ColorEvent colorEvent) {
        this.setFontColor(colorEvent.getColor());
    }
}

