/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao.menuSelector;

import difusor.controle.CommunicationController;
import igraf.IGraf;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.visao.menu.IgrafMenu;
import igraf.moduloCentral.visao.menu.MenuAjuda;
import igraf.moduloCentral.visao.menu.MenuAnimacao;
import igraf.moduloCentral.visao.menu.MenuCalculo;
import igraf.moduloCentral.visao.menu.MenuEdicao;
import igraf.moduloCentral.visao.menu.MenuExercicio;
import igraf.moduloCentral.visao.menu.MenuGrafico;
import igraf.moduloExercicio.visao.menuSelector.DisabableMenuItem;
import igraf.moduloExercicio.visao.menuSelector.DisableMenuEvent;
import igraf.moduloExercicio.visao.menuSelector.MenuItemPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class MenuSelectorFrame
extends JFrame
implements ActionListener {
    public static final String IGCLASSPATH = "igraf/moduloExercicio/visao/menuSelector/MenuSelectorFrame.java";
    private static final boolean DEBUG = false;
    public static final Color corBackground = EsquemaVisual.corBackground;
    public static final Color corForeground = EsquemaVisual.corForeground;
    public static final Color corTitle = EsquemaVisual.corTitle;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel centerPanel;
    private JButton confirmButton;
    private JPanel jPanel1;
    private JLabel labelTopInformation;
    private CommunicationController cc;
    private MenuItemPanel menuItemPanel1;
    private MenuItemPanel menuItemPanel2;
    private MenuItemPanel menuItemPanel3;
    private MenuItemPanel menuItemPanel4;
    private MenuItemPanel menuItemPanel5;
    private MenuItemPanel menuItemPanel6;
    private MenuItemPanel menuItemPanel7;
    private StringBuffer stringInvisiblesButtons = new StringBuffer();
    private boolean hasMenuItemChange = false;
    private HashMap hashMapMenus = new HashMap();
    private HashMap hashMapPopupMenus = new HashMap();
    private HashMap hashMapOfConfigItems = new HashMap();
    private static final String[] vectorOfMenuNames = new String[]{"menuGrf", "menuCalculo", "menuAnim", "menuEdicao", "menuExerc", "menuAjuda"};

    public void setHashMapMenus(HashMap hashMap) {
        this.hashMapMenus = hashMap;
    }

    public void setHashMapPopupMenus(HashMap hashMap) {
        this.hashMapPopupMenus = hashMap;
    }

    public void setMenuItemsVisible(HashMap hashMap) {
        this.hashMapPopupMenus = hashMap;
        this.setMenuItemsVisible("menuGrf");
        this.setMenuItemsVisible("menuCalculo");
        this.setMenuItemsVisible("menuAnim");
        this.setMenuItemsVisible("menuEdicao");
        this.setMenuItemsVisible("menuExerc");
        this.setMenuItemsVisible("menuAjuda");
    }

    public void setMenuItemsVisible(String string) {
        JMenuItem[] jMenuItemArray = (JMenuItem[])this.hashMapPopupMenus.get(string);
        DisabableMenuItem[] disabableMenuItemArray = (DisabableMenuItem[])this.hashMapOfConfigItems.get(string);
        int n = disabableMenuItemArray.length;
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (jMenuItemArray != null) {
                DisabableMenuItem disabableMenuItem = disabableMenuItemArray[i];
                JMenuItem jMenuItem = jMenuItemArray[i];
                bl = jMenuItem.isVisible();
                disabableMenuItem.setItemChecked(bl);
                continue;
            }
            ++n2;
        }
        if (n2 > 0) {
            System.out.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: in config menus window: the menu item vector is missing..." + n2 + ": vecJMenuItem=" + jMenuItemArray);
        }
    }

    private void buildItemPanel(String string, MenuItemPanel menuItemPanel, String[] stringArray, String[] stringArray2, int n) {
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = n;
        String string2 = IgrafMenu.SEP;
        DisabableMenuItem[] disabableMenuItemArray = new DisabableMenuItem[n2];
        for (int i = 0; i < n2; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || string3.equals(string2)) continue;
            String string4 = stringArray2[i];
            DisabableMenuItem disabableMenuItem = new DisabableMenuItem(ResourceReader.msg(string3), ResourceReader.msg(string4), n4++);
            disabableMenuItem.setBackground(corBackground);
            disabableMenuItem.setForeground(corForeground);
            disabableMenuItemArray[n3++] = disabableMenuItem;
            menuItemPanel.add(disabableMenuItem);
        }
        DisabableMenuItem[] disabableMenuItemArray2 = new DisabableMenuItem[n3];
        for (int i = 0; i < n3; ++i) {
            disabableMenuItemArray2[i] = disabableMenuItemArray[i];
        }
        this.hashMapOfConfigItems.put(string, disabableMenuItemArray2);
    }

    private void buildAllMenus() {
        this.buildItemPanel("menuGrf", this.menuItemPanel1, MenuGrafico.getMenuItensName(), MenuGrafico.getMenuItemsTooltips(), 100);
        this.buildItemPanel("menuCalculo", this.menuItemPanel2, MenuCalculo.getMenuItensName(), MenuCalculo.getMenuItemsTooltips(), 200);
        this.buildItemPanel("menuAnim", this.menuItemPanel3, MenuAnimacao.getMenuItensName(), MenuAnimacao.getMenuItemsTooltips(), 300);
        this.buildItemPanel("menuEdicao", this.menuItemPanel5, MenuEdicao.getMenuItensName(), MenuEdicao.getMenuItemsTooltips(), 500);
        this.buildItemPanel("menuExerc", this.menuItemPanel6, MenuExercicio.getMenuItensNameSM(), MenuExercicio.getMenuItemsTooltips(), 600);
        this.buildItemPanel("menuAjuda", this.menuItemPanel7, MenuAjuda.getMenuItensName(), MenuAjuda.getMenuItemsTooltips(), 700);
    }

    public MenuSelectorFrame(CommunicationController communicationController) {
        this();
        this.cc = communicationController;
        this.setVisible(false);
    }

    public MenuSelectorFrame() {
        this.initComponents();
        this.buildAllMenus();
        this.setBackground(corBackground);
        this.buttonPanel.setBackground(corBackground);
        this.centerPanel.setBackground(corBackground);
        this.cancelButton.setBackground(corBackground);
        this.confirmButton.setBackground(corBackground);
        this.labelTopInformation.setBackground(corBackground);
        this.jPanel1.setBackground(corBackground);
        this.setForeground(corForeground);
        this.buttonPanel.setForeground(corForeground);
        this.centerPanel.setForeground(corForeground);
        this.cancelButton.setForeground(corForeground);
        this.confirmButton.setForeground(corForeground);
        this.labelTopInformation.setForeground(corForeground);
        this.jPanel1.setForeground(corForeground);
        this.confirmButton.addActionListener(this);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuSelectorFrame.this.goAway();
            }
        });
    }

    private void initComponents() {
        this.setTitle("iGraf - " + ResourceReader.msg("menuCfgTitle"));
        this.getContentPane().setBackground(corBackground);
        this.labelTopInformation = new JLabel();
        this.labelTopInformation.setText(ResourceReader.msg("menuCfgTopMessage1"));
        this.labelTopInformation.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.getContentPane().add((Component)this.labelTopInformation, "First");
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new GridLayout(2, 4, 2, 2));
        this.menuItemPanel1 = new MenuItemPanel(ResourceReader.msg("menuGrf"));
        this.menuItemPanel2 = new MenuItemPanel(ResourceReader.msg("menuCalculo"));
        this.menuItemPanel3 = new MenuItemPanel(ResourceReader.msg("menuAnim"));
        this.menuItemPanel5 = new MenuItemPanel(ResourceReader.msg("menuEdicao"));
        this.menuItemPanel6 = new MenuItemPanel(ResourceReader.msg("menuExerc"));
        this.menuItemPanel7 = new MenuItemPanel(ResourceReader.msg("menuAjuda"));
        this.centerPanel.add(this.menuItemPanel1);
        this.centerPanel.add(this.menuItemPanel2);
        this.centerPanel.add(this.menuItemPanel3);
        this.centerPanel.add(this.menuItemPanel5);
        this.centerPanel.add(this.menuItemPanel6);
        this.centerPanel.add(this.menuItemPanel7);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.jPanel1 = new JPanel();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.confirmButton = new JButton();
        this.buttonPanel.setLayout(new BorderLayout());
        this.cancelButton.setText(ResourceReader.msg("msgCancelar"));
        this.confirmButton.setText(ResourceReader.msg("menuCfgConfim"));
        this.jPanel1.add(this.cancelButton);
        this.jPanel1.add(this.confirmButton);
        this.buttonPanel.add((Component)this.jPanel1, "East");
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    public void updateLabes() {
        this.setTitle("iGraf - " + ResourceReader.msg("menuCfgTitle"));
        this.menuItemPanel1.setText(ResourceReader.msg("menuGrf"));
        this.menuItemPanel2.setText(ResourceReader.msg("menuCalculo"));
        this.menuItemPanel3.setText(ResourceReader.msg("menuAnim"));
        this.menuItemPanel5.setText(ResourceReader.msg("menuEdicao"));
        this.menuItemPanel6.setText(ResourceReader.msg("menuExerc"));
        this.menuItemPanel7.setText(ResourceReader.msg("menuAjuda"));
        this.labelTopInformation.setText(ResourceReader.msg("menuCfgTopMessage1"));
        this.cancelButton.setText(ResourceReader.msg("msgCancelar"));
        this.confirmButton.setText(ResourceReader.msg("menuCfgConfim"));
    }

    private void goAway() {
        this.setVisible(false);
        this.dispose();
    }

    public void processChangesToMenus() {
        int n = vectorOfMenuNames.length;
        this.stringInvisiblesButtons = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            String string = vectorOfMenuNames[i];
            JMenuItem[] jMenuItemArray = (JMenuItem[])this.hashMapPopupMenus.get(string);
            DisabableMenuItem[] disabableMenuItemArray = (DisabableMenuItem[])this.hashMapOfConfigItems.get(string);
            int n2 = disabableMenuItemArray.length;
            for (int j = 0; j < n2; ++j) {
                boolean bl;
                boolean bl2 = jMenuItemArray[j].isVisible();
                if (bl2 != (bl = disabableMenuItemArray[j].isSelected())) {
                    this.hasMenuItemChange = true;
                    jMenuItemArray[j].setVisible(bl);
                }
                if (bl) continue;
                this.stringInvisiblesButtons.append(String.valueOf(disabableMenuItemArray[j].getMenuCode()) + ", ");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.processChangesToMenus();
        if (this.hasMenuItemChange) {
            this.cc.enviarEvento(new DisableMenuEvent(this, this.getDisableList()));
        }
        this.goAway();
    }

    public String getDisableList() {
        if (this.stringInvisiblesButtons.toString().length() > 2) {
            return this.stringInvisiblesButtons.toString().substring(0, this.stringInvisiblesButtons.length() - 2);
        }
        return "";
    }

    public static void main(String[] stringArray) {
        new MenuSelectorFrame().setVisible(true);
    }
}

