/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.basico.util.Funcao;
import igraf.basico.util.GeraPoligono;
import igraf.basico.util.Utilitarios;
import igraf.moduloCentral.eventos.DesenhoTangenteEvent;
import igraf.moduloCentral.visao.desenho.DesenhoFuncao;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.Graphics2D;

public class DesenhoTangente
extends DesenhoFuncao {
    private double valorX;
    private double valorY;
    private double coefAngular;
    private double coefLinear;
    private double i = 0.04;
    private String equacaoReta;
    private Funcao f;
    private boolean animacao;
    Plotter plotter;

    public DesenhoTangente(Plotter plotter, String string, int n, double d) {
        super(plotter, string, n);
        this.plotter = plotter;
        this.f = new Funcao(1);
        this.f.constroiExpressao(string);
        this.f.derivaFuncao((byte)1);
        this.setValorX(d);
    }

    public void setValorX(double d) {
        this.valorX = d;
        this.calculaCoeficientes();
        this.determinaEquacao();
    }

    private void calculaCoeficientes() {
        this.valorY = this.f.f(this.valorX);
        this.coefAngular = this.f.fD(this.valorX);
        this.coefLinear = this.valorY - this.coefAngular * this.valorX;
    }

    private void determinaEquacao() {
        String string = "+";
        String string2 = Utilitarios.precisao(this.coefLinear);
        if (string2.indexOf(45) != -1) {
            string = null;
            string = "";
        }
        this.equacaoReta = Utilitarios.precisao(this.coefAngular) + " * x " + string + " " + string2;
    }

    public String getEquacaoReta() {
        return this.equacaoReta;
    }

    public String getValorX() {
        return Utilitarios.precisao(this.valorX);
    }

    public String getFx() {
        return Utilitarios.precisao(this.valorY);
    }

    public void atualizaDesenho(Graphics2D graphics2D) {
        this.animar();
        this.polygonToBeDrawn = GeraPoligono.getGrafico(this.equacaoReta, this.getXMin(), this.getXMax(), this.getEscala());
        this.renderiza(this.polygonToBeDrawn, graphics2D);
    }

    private void animar() {
        boolean bl = false;
        if (this.animacao) {
            this.setValorX(this.valorX += this.i);
            if (this.valorX < (double)this.getXMin() / (double)this.getEscala() || this.valorX > (double)this.getXMax() / (double)this.getEscala()) {
                this.i = -this.i;
            }
        }
        this.plotter.enviarEvento(new DesenhoTangenteEvent(this, this.getEquacaoReta(), this.getValorX(), this.getFx()));
    }

    public void setAnimacao(boolean bl) {
        this.animacao = bl;
    }

    public String getFuncaoAtual() {
        return this.equacaoReta;
    }
}

