/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.menu;

import difusor.CommunicationFacade;
import difusor.evento.CommunicationEvent;
import igraf.IGraf;
import igraf.basico.event.ChangeLanguageEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.eventos.LoadingAppletEvent;
import igraf.moduloCentral.controle.menu.IgrafMenuController;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuExercicioEvent;
import igraf.moduloCentral.visao.menu.IgrafMenu;
import igraf.moduloCentral.visao.menu.MenuExercicio;
import igraf.moduloExercicio.visao.menuSelector.DisableMenuEvent;

public class IgrafMenuExercicioController
extends IgrafMenuController {
    private IgrafMenuExercicioEvent imee;
    private MenuExercicio me;
    private boolean temAnimacao;
    private boolean temAnimacaoOculta;
    private boolean temFuncao;
    private boolean temFuncaoOculta;
    private boolean temResposta;
    private boolean temPoligono;
    private boolean exercicioCarregado;

    public IgrafMenuExercicioController(CommunicationFacade communicationFacade, boolean bl, int n) {
        super(communicationFacade, bl, n);
        this.me = new MenuExercicio(this, n);
    }

    public void enviarEventoAcao(String string) {
        System.out.println("src/igraf/moduloCentral/controle/menu/IgrafMenuExercicioController.java: enviarEventoAcao: " + string);
        this.imee = new IgrafMenuExercicioEvent(this);
        this.imee.setCommand(string);
        this.enviarEvento(this.imee);
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        String string = communicationEvent.getCommand();
        if (communicationEvent instanceof DisableMenuEvent) {
            this.removeDisabledMenuItens(communicationEvent);
            return;
        }
        if (string.equals("read exercise")) {
            this.setExercise(true);
            return;
        }
        if (communicationEvent instanceof ChangeLanguageEvent) {
            this.me.updateLabels();
            return;
        }
        if (communicationEvent instanceof LoadingAppletEvent && IGraf.ehApplet && (IGraf.iLM_PARAM_authoring == null || !IGraf.iLM_PARAM_authoring.equals("true"))) {
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercCriar"), false);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercEditar"), false);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercMenuConfig"), false);
            int n = this.me.removeMenuItem("mexExercCriar");
            n = this.me.removeMenuItem("mexExercEditar");
            n = this.me.removeMenuItem("mexExercMenuConfig");
        }
        if (string.equals("reset")) {
            this.setStudentAnswer(false);
            this.setExercise(false);
            return;
        }
        if (communicationEvent instanceof IgrafTabUpdateEvent && (string.equals("changeFunctionList") || string.equals("changePolygonList") || string.equals("changeAnimationList"))) {
            IgrafTabUpdateEvent igrafTabUpdateEvent = (IgrafTabUpdateEvent)communicationEvent;
            String string2 = igrafTabUpdateEvent.getCommand();
            if (string2.equals("changeFunctionList")) {
                this.temFuncao = igrafTabUpdateEvent.getFunctionList().size() > 0;
                this.temFuncaoOculta = igrafTabUpdateEvent.temDesenhoOculto();
            } else if (string2.equals("changePolygonList")) {
                this.temPoligono = igrafTabUpdateEvent.isPolygonListChanged();
            } else if (string2.equals("changeAnimationList")) {
                this.temAnimacao = igrafTabUpdateEvent.getAnimationList().size() > 0;
                this.temAnimacaoOculta = igrafTabUpdateEvent.temDesenhoOculto();
            }
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercHistorico"), this.temFuncaoOculta | this.temAnimacaoOculta | this.temPoligono);
            if (igrafTabUpdateEvent.isItExercise()) {
                this.setExercise(true);
            } else if (!this.exercicioCarregado) {
                this.setExercise(false);
            }
        }
        if (string.equals("load result")) {
            this.setStudentAnswer(true);
        } else if (string.equals(ResourceReader.msg("msgMenuGrfNovaSes"))) {
            this.setExercise(false);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercHistorico"), false);
        }
        this.modoExameResposta();
    }

    private void modoExameResposta() {
    }

    private void setExercise(boolean bl) {
        this.exercicioCarregado = true;
        this.me.setEnabledMenuItem(ResourceReader.msg("mexExercResp"), bl);
        if (!IGraf.ehApplet || IGraf.iLM_PARAM_authoring != null && IGraf.iLM_PARAM_authoring.equals("true")) {
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercEval"), true);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercCriar"), true);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercEditar"), true);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercMenuConfig"), true);
        } else {
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercCriar"), bl);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercEditar"), false);
            this.me.setEnabledMenuItem(ResourceReader.msg("mexExercMenuConfig"), false);
            int n = this.me.removeMenuItem("mexExercCriar");
            n = this.me.removeMenuItem("mexExercEditar");
            n = this.me.removeMenuItem("mexExercMenuConfig");
        }
    }

    private void setStudentAnswer(boolean bl) {
        this.me.setEnabledMenuItem(ResourceReader.msg("mexExercEval"), bl);
        this.me.setEnabledMenuItem(ResourceReader.msg("mexExercResp"), !bl);
    }

    private void removeDisabledMenuItens(CommunicationEvent communicationEvent) {
        DisableMenuEvent disableMenuEvent = (DisableMenuEvent)communicationEvent;
        int[] nArray = disableMenuEvent.getDisableList();
        int n = nArray == null ? 0 : nArray.length;
        int n2 = 0;
        while (n2 < n && nArray[n2] < 699) {
            switch (nArray[n2++]) {
                case 600: {
                    this.me.removeMenuItem("mexExercHistorico");
                    break;
                }
                case 601: {
                    this.me.removeMenuItem("mexExercResp");
                    break;
                }
                case 602: {
                    this.me.removeMenuItem("mexExercEval");
                    break;
                }
                case 603: {
                    this.me.removeMenuItem("mexExercCriar");
                    break;
                }
                case 604: {
                    this.me.removeMenuItem("mexExercEditar");
                    break;
                }
                case 605: {
                    this.me.removeMenuItem("mexExercMenuConfig");
                }
            }
        }
    }

    public void setControlledObject(Object object) {
        this.me = (MenuExercicio)object;
    }

    public IgrafMenu getMenu() {
        return this.me;
    }
}

