/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.desenho;

import difusor.evento.CommunicationEvent;
import igraf.moduloCentral.controle.desenho.DesenhoController;
import igraf.moduloCentral.eventos.DesenhoTextoEvent;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.visao.desenho.DesenhoTexto;
import igraf.moduloCentral.visao.plotter.GraphPlotter;

public class DesenhoTextoController
extends DesenhoController {
    private int ordem = 0;
    private int lastId = 0;

    public DesenhoTextoController(GraphPlotter graphPlotter) {
        super(graphPlotter);
        DesenhoTextoEvent.textId = 0;
    }

    public void trataEvento(CommunicationEvent communicationEvent) {
        DesenhoTextoEvent desenhoTextoEvent;
        String string = communicationEvent.getCommand();
        if (string.equals("editText")) {
            desenhoTextoEvent = (DesenhoTextoEvent)communicationEvent;
            this.listaDesenho.add(desenhoTextoEvent.getDesenhoTexto());
        }
        if (string.equals("eraseText")) {
            desenhoTextoEvent = (DesenhoTextoEvent)communicationEvent;
            int n = desenhoTextoEvent.getEraseIndex();
            if (n < this.listaDesenho.size()) {
                this.listaDesenho.remove(n);
            }
            this.notificaAlteracaoEstado();
        }
        if (string.equals("insertText")) {
            float f = 1.0f;
            DesenhoTextoEvent desenhoTextoEvent2 = (DesenhoTextoEvent)communicationEvent;
            DesenhoTexto desenhoTexto = new DesenhoTexto(this.plotter, desenhoTextoEvent2.getTextoAtual(), this.ordem++);
            desenhoTexto.setFontColor(desenhoTextoEvent2.getFontColor());
            float f2 = desenhoTextoEvent2.getTextPositionX();
            float f3 = desenhoTextoEvent2.getTextPositionY();
            if (desenhoTextoEvent2.versaoAntiga()) {
                f = this.plotter.getEscala();
                f3 = -f3 / f;
                desenhoTextoEvent2.setTextPosition(f2 /= f, f3);
                desenhoTextoEvent2.clearVersao();
                this.enviarEvento(desenhoTextoEvent2);
            }
            desenhoTexto.setPosition(f2, f3);
            desenhoTexto.setFontSize(desenhoTextoEvent2.getFontSize());
            if (this.lastId != DesenhoTextoEvent.textId) {
                this.insereDesenho(desenhoTexto);
                this.lastId = DesenhoTextoEvent.textId;
                this.notificaAlteracaoEstado();
            }
        }
    }

    public void removeTexto(int n) {
        this.listaDesenho.removeElementAt(n);
    }

    public void notificaAlteracaoEstado() {
        IgrafTabUpdateEvent igrafTabUpdateEvent = new IgrafTabUpdateEvent(this, "textListChanged");
        igrafTabUpdateEvent.setTextListSize(this.listaDesenho.size());
        this.enviarEvento(igrafTabUpdateEvent);
    }

    public void reset() {
        super.reset();
        this.ordem = 0;
    }
}

