/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.desenho;

import difusor.evento.CommunicationEvent;
import igraf.moduloCentral.controle.desenho.DesenhoController;
import igraf.moduloCentral.visao.desenho.DesenhoTangente;
import igraf.moduloCentral.visao.plotter.GraphPlotter;
import igraf.moduloJanelasAuxiliares.eventos.JanelaTangenteEvent;
import java.util.Vector;

public class DesenhoTangenteController
extends DesenhoController {
    boolean multiDrawMode;
    private DesenhoTangente dt;

    public DesenhoTangenteController(GraphPlotter graphPlotter) {
        super(graphPlotter);
        this.listaDesenho = new Vector();
    }

    public void removeTangente() {
        try {
            this.listaDesenho.removeElementAt(this.listaDesenho.size() - 1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void removeTangente(String string) {
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            this.dt = (DesenhoTangente)this.listaDesenho.elementAt(i);
            String string2 = this.dt.getFuncaoOriginal();
            if (!string2.equals(string)) continue;
            this.listaDesenho.remove(i);
            return;
        }
    }

    public void insereDesenhoTangente(String string, double d) {
        int n = this.plotter.getCorDesenho(string);
        try {
            this.listaDesenho.addElement(new DesenhoTangente(this.plotter, string, n, d));
        }
        catch (Exception exception) {
            System.out.println("GerenciadorTangente.removeTodasTangentes/nErro: cor inconsistente");
            exception.printStackTrace();
        }
        this.multiDrawMode = false;
    }

    public boolean atualizaDesenhoTangente(String string, double d) {
        int n = -1;
        for (int i = this.listaDesenho.size() - 1; i > -1; --i) {
            if (!this.listaDesenho.elementAt(i).toString().equals(string)) continue;
            n = i;
        }
        if (n > -1) {
            this.dt = (DesenhoTangente)this.listaDesenho.elementAt(n);
            this.dt.setValorX(d);
            return true;
        }
        return false;
    }

    public String getFx(String string) {
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            DesenhoTangente desenhoTangente = (DesenhoTangente)this.listaDesenho.elementAt(i);
            if (!desenhoTangente.toString().equals(string)) continue;
            return desenhoTangente.getFx();
        }
        return "";
    }

    public void setAnimacaoTangente(String string, boolean bl) {
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            this.dt = (DesenhoTangente)this.listaDesenho.elementAt(i);
            this.dt.setAnimacao(bl);
        }
    }

    public void trataEvento(CommunicationEvent communicationEvent) {
        JanelaTangenteEvent janelaTangenteEvent = (JanelaTangenteEvent)communicationEvent;
        String string = janelaTangenteEvent.getCommand();
        if (string.equals("drawTangent")) {
            if (this.multiDrawMode) {
                this.insereDesenhoTangente(janelaTangenteEvent.getFuncaoAtual(), janelaTangenteEvent.getValorX());
                return;
            }
            if (!this.atualizaDesenhoTangente(janelaTangenteEvent.getFuncaoAtual(), janelaTangenteEvent.getValorX())) {
                this.insereDesenhoTangente(janelaTangenteEvent.getFuncaoAtual(), janelaTangenteEvent.getValorX());
            }
        }
        if (string.equals("eraseTangent")) {
            this.listaDesenho.removeAllElements();
        } else if (string.equals("animTangent")) {
            this.setAnimacaoTangente(janelaTangenteEvent.getFuncaoAtual(), janelaTangenteEvent.getAnimationMode());
            this.multiDrawMode = false;
        } else if (string.equals("multiDraw")) {
            this.multiDrawMode = janelaTangenteEvent.getDrawMode();
        }
    }
}

