/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.desenho;

import difusor.evento.CommunicationEvent;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.util.Vector;

public abstract class DesenhoController {
    protected Vector listaDesenho;
    protected Plotter plotter;

    public DesenhoController(Plotter plotter) {
        this.plotter = plotter;
        this.listaDesenho = new Vector();
    }

    protected void limpaListaDesenho() {
        this.listaDesenho.removeAllElements();
    }

    protected void enviarEvento(CommunicationEvent communicationEvent) {
        this.plotter.enviarEvento(communicationEvent);
    }

    public Vector getListaDesenho() {
        return this.listaDesenho;
    }

    public Vector getListaDesenhoSemReferencia() {
        Vector vector = this.listaDesenho.size() == 0 ? new Vector() : new Vector(this.listaDesenho);
        return vector;
    }

    public void setListaDesenho(Vector vector) {
        this.listaDesenho = vector;
    }

    public boolean insereDesenho(Desenho desenho) {
        this.listaDesenho.add(desenho);
        return true;
    }

    void notifyScreenChanged() {
        this.plotter.notifyScreenChanged();
    }

    public int getNumDesenhos() {
        return this.listaDesenho.size();
    }

    public Desenho getDesenho(int n) {
        return (Desenho)this.listaDesenho.get(n);
    }

    boolean ehDesenhoVisivel(String string) {
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            Desenho desenho = (Desenho)this.listaDesenho.get(i);
            if (!desenho.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public abstract void trataEvento(CommunicationEvent var1);

    public void reset() {
        this.listaDesenho.removeAllElements();
    }
}

