/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloSuperior.controle.entrada;

import difusor.CommunicationFacade;
import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.IGraf;
import igraf.basico.event.AttentionToolTip;
import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuCalculoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloInferior.visao.InfoPane;
import igraf.moduloSuperior.controle.entrada.Analisa;
import igraf.moduloSuperior.eventos.EntradaExpressaoEvent;
import igraf.moduloSuperior.visao.EntradaExpressao;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.JTextComponent;

public class EntradaExpressaoController
extends CommunicationController
implements ActionListener,
KeyListener {
    public static final String IGCLASSPATH = "igraf/moduloSuperior/controle/entrada/EntradaExpressaoController.java";
    private boolean funcaoCorreta;
    private boolean enterPressed;
    private JTextComponent editor;
    private String lastExpr = "";
    private IgrafTabUpdateEvent igrafTabUpdateEvent = new IgrafTabUpdateEvent(this, "changeExpression");
    private EntradaExpressao entradaExpressao;
    private InfoPane infoPane;

    public void setInfoPanel(InfoPane infoPane) {
        this.infoPane = infoPane;
    }

    public EntradaExpressaoController(CommunicationFacade communicationFacade, boolean bl) {
        super(communicationFacade, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.entradaExpressao.getSelectedItem();
        if (string != null && string.length() > 0 && this.enterPressed) {
            this.enviaFuncaoDesenho(string);
            this.enterPressed = false;
        }
    }

    private void enviaFuncaoDesenho(String string) {
        if (string.equals("")) {
            return;
        }
        this.funcaoCorreta = Analisa.verificaFuncao(string);
        if (this.funcaoCorreta && Analisa.getErrorMessage() == "") {
            this.igrafTabUpdateEvent.setExpression(string);
            this.enviarEvento(this.igrafTabUpdateEvent);
            this.entradaExpressao.setText(string);
            this.enviarEvento(new EntradaExpressaoEvent(this, string));
        } else {
            String string2 = ResourceReader.msg("exercRAErroExpInv") + "\"" + string + "\" - " + Analisa.getErrorMessage();
            System.out.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: enviaFuncaoDesenho(" + string + "): " + string2);
            AttentionToolTip.showToolTipText(this.entradaExpressao, string2);
            this.entradaExpressao.setToolTipText(string);
            this.infoPane.setStatusBarMessage(string2);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.enterPressed = true;
        }
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        String string;
        CommunicationEvent communicationEvent2;
        String string2 = communicationEvent.getCommand();
        if (string2.equals(ResourceReader.msg("msgMenuGrfNovaSes"))) {
            this.editor.setText("");
        } else if (string2.equals(ResourceReader.msg("setInputExpression"))) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: event erased!!! " + communicationEvent.getClass().getName());
        }
        if (communicationEvent instanceof IgrafMenuGraficoEvent) {
            String string3;
            communicationEvent2 = (IgrafMenuGraficoEvent)communicationEvent;
            if (!((IgrafMenuGraficoEvent)communicationEvent2).getExpressao().equals("")) {
                return;
            }
            string = communicationEvent2.getCommand();
            if (string.equals(ResourceReader.msg("msgMenuGrfDes"))) {
                this.enviaFuncaoDesenho(this.editor.getText());
            } else if ((string.equals("msgMenuGrfEsconder") || string.equals("msgMenuGrfRemoverGrafico")) && (string3 = this.editor.getText()).length() > 0) {
                ((IgrafMenuGraficoEvent)communicationEvent2).setExpressao(this.editor.getText());
                this.enviarEvento(communicationEvent2);
            }
        }
        if (communicationEvent instanceof IgrafMenuCalculoEvent) {
            communicationEvent2 = (IgrafMenuCalculoEvent)communicationEvent;
            if (!((IgrafMenuCalculoEvent)communicationEvent2).getExpressao().equals("")) {
                return;
            }
            if ((communicationEvent2.getCommand().equals(ResourceReader.msg("mcDerVer")) || communicationEvent2.getCommand().equals(ResourceReader.msg("mcIIVer"))) && (string = this.editor.getText()).length() > 0) {
                ((IgrafMenuCalculoEvent)communicationEvent2).setExpressao(string);
                this.enviarEvento(communicationEvent2);
            }
        }
        if (communicationEvent instanceof IgrafTabUpdateEvent && (communicationEvent2 = (IgrafTabUpdateEvent)communicationEvent).getCommand().equals("general update")) {
            this.editor.setText(((IgrafTabUpdateEvent)communicationEvent2).getExpression());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        String string = this.editor.getText().trim();
        if (string.length() < 1 | string.equals(this.lastExpr)) {
            return;
        }
        this.lastExpr = string;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setControlledObject(Object object) {
        this.entradaExpressao = (EntradaExpressao)object;
        this.editor = this.entradaExpressao.getTextEditor();
    }
}

