/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao.integral;

import igraf.IGraf;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Utilitarios;
import igraf.moduloJanelasAuxiliares.controle.JanelaIntegralController;
import igraf.moduloJanelasAuxiliares.eventos.JanelaIntegralEvent;
import igraf.moduloJanelasAuxiliares.visao.ChoicePanel;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;

public class PainelIntegral
extends Panel
implements KeyListener {
    public static final String IGCLASSPATH = "";
    private Panel painelAuxiliar1 = new Panel(new GridLayout(0, 1, 0, 4));
    private Panel painelAuxiliar2;
    private String limiteInf;
    private String limiteSup;
    private String fSuperior;
    private String fInferior;
    private double intSuperior;
    private double de;
    private double a;
    private double delta = 0.02;
    private TextField inf = new TextField("0", 10);
    private TextField sup = new TextField("1", 10);
    private Button integrar = new Button(ResourceReader.msg("btInteg"));
    private Checkbox cb;
    private Dimension d = new Dimension(192, 60);
    private Label labelResultado = new Label(ResourceReader.msg("btResult"));
    private Label labelIntegral = new Label();
    private Color corLetra = Color.black;
    protected ChoicePanel cp1;
    protected ChoicePanel cp2;
    private final int ESQUERDA = 37;
    private final int DIREITA = 39;
    private final int BAIXO = 40;
    private final int CIMA = 38;
    private JanelaIntegralController jic;

    public PainelIntegral(JanelaIntegralController janelaIntegralController) {
        this.jic = janelaIntegralController;
        this.setBackground(new Color(247, 247, 247));
        this.linhaUm();
        this.linhaDois();
        this.linhaTres();
        this.add(this.painelAuxiliar1);
    }

    private void linhaUm() {
        this.cp1 = new ChoicePanel(ResourceReader.msg("funSup"));
        this.painelAuxiliar1.add(this.cp1);
    }

    private void linhaDois() {
        this.cp2 = new ChoicePanel(ResourceReader.msg("funInf"));
        this.painelAuxiliar1.add(this.cp2);
    }

    private void linhaTres() {
        Panel panel = new Panel(new GridLayout(1, 2, 5, 0)){

            public Dimension getPreferredSize() {
                return new Dimension(185, 20);
            }
        };
        this.painelAuxiliar2 = new Panel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return PainelIntegral.this.d;
            }

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                graphics.setColor(Color.blue);
                graphics.drawString(ResourceReader.msg("intInterv"), 10, 16);
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            }

            public Insets getInsets() {
                return new Insets(0, 5, 5, 4);
            }
        };
        this.inf.setForeground(this.corLetra);
        this.sup.setForeground(this.corLetra);
        this.inf.addKeyListener(this);
        this.sup.addKeyListener(this);
        panel.add(this.inf);
        panel.add(this.sup);
        this.painelAuxiliar2.add((Component)panel, "South");
        this.painelAuxiliar1.add("South", this.painelAuxiliar2);
    }

    public Insets getInsets() {
        return new Insets(0, 10, 0, 10);
    }

    public Dimension getPreferredSize() {
        return new Dimension(210, 325);
    }

    public void pintaRegiao(String string) {
        String[] stringArray = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            n = string.indexOf("from:");
            n2 = string.indexOf(" ", n);
            d = Double.valueOf(string.substring(n + 5, n2));
            n = string.indexOf("to:");
            n2 = string.indexOf(" ", n);
            d2 = Double.valueOf(string.substring(n + 3, n2));
            n = string.indexOf("modo:");
            n2 = string.indexOf(" ", n);
            bl = Boolean.valueOf(string.substring(n + 5, n2));
            n = string.indexOf("list:");
            stringArray = this.refazLista(string.substring(n + 5));
        }
        catch (Exception exception) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: in panel of integrals: " + "A string de entrada n\u00e3o est\u00e1 de acordo com o padr\u00e3o esperado\n");
            exception.printStackTrace();
        }
        this.pintaRegiao(stringArray, d, d2, bl);
    }

    private String[] refazLista(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void pintaRegiao(String[] stringArray, double d, double d2, boolean bl) {
        if (Math.abs(d - d2) > 0.0) {
            this.limpaRegiao();
            this.jic.enviarEvento(new JanelaIntegralEvent(this, stringArray, d, d2));
        }
    }

    public void limpaRegiao() {
        this.jic.enviarEvento(new JanelaIntegralEvent(this));
    }

    public void mudaPinturaRegiao(boolean bl) {
        this.jic.enviarEvento(new JanelaIntegralEvent((Object)this, bl));
    }

    double getFrom() {
        return this.getValue(this.inf);
    }

    double getTo() {
        return this.getValue(this.sup);
    }

    private double getValue(TextField textField) {
        String string = textField.getText();
        string = Analisa.verificaConstante(string);
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    protected String[] getListaFuncoesSelecionadas() {
        String string = this.cp2.getSelectedItem();
        try {
            if (string.indexOf(60) > -1) {
                string = "0";
            }
        }
        catch (Exception exception) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: in panel of integrals: " + exception.toString());
        }
        String string2 = this.cp1.getSelectedItem();
        if (string2 == null) {
            string2 = "0";
        }
        String[] stringArray = new String[]{string2, string};
        return stringArray;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        TextField textField = (TextField)keyEvent.getSource();
        double d = this.getValue(textField);
        if (n == 37 || n == 40) {
            textField.setText(Utilitarios.precisao(d -= this.delta));
        }
        if (n == 39 || n == 38) {
            textField.setText(Utilitarios.precisao(d += this.delta));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void updateLabels() {
        this.integrar.setLabel(ResourceReader.msg("btInteg"));
        this.labelResultado.setText(ResourceReader.msg("btResult"));
        this.cp1.setLabel(ResourceReader.msg("funSup"));
        this.cp2.setLabel(ResourceReader.msg("funInf"));
        this.painelAuxiliar2.repaint();
    }
}

