/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao;

import igraf.IGraf;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Crypto;
import igraf.basico.util.Funcao;
import igraf.moduloCentral.visao.desenho.DesenhoFuncao;
import igraf.moduloExercicio.visao.JanelaExercicio;
import igraf.moduloExercicio.visao.PainelRespostaNumerica;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PainelRespostaAlgebrica
extends PainelRespostaNumerica {
    public static final String IGCLASSPATH = "igraf/moduloExercicio/visao/PainelRespostaAlgebrica.java: ";
    private String strItem;
    private int start;
    private int end;
    private JComboBox choice;

    public PainelRespostaAlgebrica(JanelaExercicio janelaExercicio, int n) {
        super(janelaExercicio, n);
        this.setLabelText(ResourceReader.msg("exercRespDica"));
    }

    public PainelRespostaAlgebrica(JanelaExercicio janelaExercicio, int n, int n2, int n3, String string) {
        this(janelaExercicio, n);
        this.janelaExercicio = janelaExercicio;
        this.setLimits(n2, n3);
        this.respostaGabarito = string;
    }

    protected void configurePanelAtRight() {
        if (JanelaExercicio.getModo() == 1) {
            super.configurePanelAtRight();
        } else {
            this.choice = new JComboBox();
            this.panel = new JPanel(new GridLayout(3, 1));
            this.adicionaConteudoDireito(this.choice);
        }
    }

    public String getResposta() {
        if (this.respostaAluno == null || this.respostaAluno == "") {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + " getResposta(): respostaAluno=" + this.respostaAluno);
            this.enviaMensagemErro(ResourceReader.msg("exercRAErroCampoResp"));
            return "";
        }
        String string = "a:" + String.valueOf(this.start) + " ";
        String string2 = "b:" + String.valueOf(this.end) + " ";
        this.strItem = "Item:" + String.valueOf(this.numQuest) + " ";
        return this.strItem + string + string2 + "val:" + Crypto.stringToHex(this.respostaAluno) + " ";
    }

    protected boolean validacaoOk(JTextField jTextField) {
        return this.validacaoOk(jTextField, true);
    }

    public int comparaResposta() {
        this.maxNumError = 1;
        if (!this.comparaFuncoes(this.respostaGabarito, this.respostaAluno, this.start, this.end)) {
            this.diagnostico = this.diagnostico + this.respostaErrada(this.respostaAluno) + "\r\n";
            this.registraDiagnostico(this.diagnostico);
            ++this.numErros;
        } else {
            this.diagnostico = this.diagnostico + this.respostaCerta(this.respostaAluno) + "\r\n";
            this.registraDiagnostico(this.respostaCerta(this.respostaAluno));
            ++this.numAcertos;
        }
        this.setValorCorrecao(this.correcao());
        this.setValorResposta(this.respostaAluno);
        return this.numErros;
    }

    private boolean comparaFuncoes(String string, String string2, double d, double d2) {
        Funcao funcao = new Funcao(1);
        Funcao funcao2 = new Funcao(1);
        int n = 0;
        funcao.constroiExpressao(string);
        funcao2.constroiExpressao(string2);
        for (double d3 = d; d3 < d2; d3 += 1.0) {
            if (Double.isNaN(funcao.f(d3)) || this.erroAceitavel(funcao.f(d3), funcao2.f(d3))) continue;
            ++n;
        }
        return n <= 0;
    }

    public void setLimits(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public void updateLabels() {
        super.updateLabels();
        this.setLabelText(ResourceReader.msg("exercRespDica"));
    }

    protected void setChoiceItens(Vector vector) {
        if (vector != null && this.choice != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.choice.insertItemAt(((DesenhoFuncao)vector.elementAt(i)).getFuncaoAtual(), i);
            }
        }
    }

    public boolean validar() {
        if (JanelaExercicio.getModo() == 1) {
            return super.validar();
        }
        this.respostaAluno = (String)this.choice.getSelectedItem();
        return true;
    }
}

