/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.plotter;

import difusor.evento.CommunicationEvent;
import igraf.moduloCentral.controle.desenho.DesenhoPoligonoController;
import igraf.moduloCentral.eventos.menu.IgrafMenuPoligonoEvent;
import igraf.moduloCentral.visao.desenho.DesenhoPoligono;
import igraf.moduloCentral.visao.plotter.Plotter;
import igraf.moduloSuperior.eventos.EntradaExpressaoEvent;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class PolygonPlotter
extends Plotter {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/plotter/PolygonPlotter.java";
    private int w = 0;
    private int h = 0;
    private BufferedImage image;
    private Graphics2D graphics;
    private DesenhoPoligonoController dpc = new DesenhoPoligonoController(this);
    private DesenhoPoligono d;
    private boolean freshMoving = false;
    private Cursor hd = new Cursor(12);
    private Cursor df = new Cursor(0);

    public void setDrawingArea(BufferedImage bufferedImage, int n, int n2) {
        this.w = n;
        this.h = n2;
        this.image = bufferedImage;
        this.graphics = this.image.createGraphics();
        this.desenha(this.graphics, n, n2);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void inserePoligono(CommunicationEvent communicationEvent) {
        Object object;
        DesenhoPoligono desenhoPoligono = null;
        if (communicationEvent instanceof IgrafMenuPoligonoEvent) {
            try {
                object = (IgrafMenuPoligonoEvent)communicationEvent;
                desenhoPoligono = new DesenhoPoligono(this, ((IgrafMenuPoligonoEvent)object).getVertexList(), ((IgrafMenuPoligonoEvent)object).getStrFillColor(), ((IgrafMenuPoligonoEvent)object).getStrLineColor(), ((IgrafMenuPoligonoEvent)object).getPolygonType(), ((IgrafMenuPoligonoEvent)object).getFillingMode(), ((IgrafMenuPoligonoEvent)object).getVertexMode());
            }
            catch (Exception exception) {
                return;
            }
        }
        if (communicationEvent instanceof EntradaExpressaoEvent) {
            object = ((EntradaExpressaoEvent)communicationEvent).getExpressao();
            desenhoPoligono = new DesenhoPoligono(this, (String)object, 0, 0);
        }
        if (desenhoPoligono != null) {
            this.dpc.inserePoligono(desenhoPoligono);
            this.dpc.modoPadrao();
        }
    }

    public void desenha(Graphics2D graphics2D, int n, int n2) {
        for (int i = 0; i < this.dpc.getNumDesenhos(); ++i) {
            this.d = (DesenhoPoligono)this.dpc.getDesenho(i);
            this.d.atualizaDesenho(graphics2D);
        }
    }

    public void trataMenuPoligonoEvent(CommunicationEvent communicationEvent) {
        this.dpc.trataEvento(communicationEvent);
    }

    public void trataMenuGraficoEvent(CommunicationEvent communicationEvent) {
        this.dpc.trataEvento(communicationEvent);
    }

    public void resetPlotter() {
        this.dpc.reset();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.dpc.modoPadrao();
            this.dpc.removeDesenho();
        }
        if (keyEvent.getModifiers() == 2 && (keyEvent.getKeyCode() == 90 || keyEvent.getKeyCode() == 68) && this.dpc.undo()) {
            this.enviarEvento(new IgrafMenuPoligonoEvent("undo_polygon", this));
        }
        if (keyEvent.getModifiers() == 2 && (keyEvent.getKeyCode() == 82 || keyEvent.getKeyCode() == 89) && this.dpc.redo()) {
            this.enviarEvento(new IgrafMenuPoligonoEvent("redo_polygon", this));
        }
    }

    public void undo() {
        this.dpc.undo();
    }

    public void redo() {
        this.dpc.redo();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.mouseOverPoint && mouseEvent.getButton() == 1 && !this.freshMoving) {
            this.dpc.postNewEdit();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.dpc.modoCriacao && !this.freshMoving) {
            this.mouseOverPoint = this.dpc.look4Point(this.xPixelToReal(mouseEvent.getX()), this.yPixelToReal(mouseEvent.getY()));
            if (this.mouseOverPoint) {
                this.father.setCursor(this.hd);
            } else {
                this.father.setCursor(this.df);
            }
        }
        if (this.freshMoving) {
            this.dpc.dragPoint(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseOverPoint) {
            this.dpc.dragPoint(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
            if (this.dpc.modoCriacao) {
                this.dpc.insereVertice(mouseEvent.getX(), mouseEvent.getY());
            } else if (this.mouseOverPoint) {
                boolean bl = this.freshMoving = !this.freshMoving;
            }
        }
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (this.dpc.getCreationType() == this.dpc.POLYGON || this.dpc.getCreationType() == this.dpc.S_POLYGON)) {
            this.dpc.encerraModoEntrada();
        }
    }

    public void notifyScreenChanged() {
    }

    public int getCorDesenho(String string) {
        return 0;
    }

    public void iniciaAnimacao(boolean bl) {
    }
}

