/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.basico.util.GeraPoligono;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class DesenhoFuncao
extends Desenho {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/desenho/DesenhoFuncao.java";
    protected String funcaoOriginal;
    protected String funcaoAtual;
    protected String dominio = "";
    protected String comentario = "";
    private boolean dominioDefinido;
    private int intervalMinimumInt;
    private int intervalMaximumInt;
    private double intervalMinimumScale;
    private double intervalMaximumScale;
    private String functionID = Desenho.getNewId();
    private boolean aIndefinido;
    private boolean bIndefinido;

    public DesenhoFuncao(Plotter plotter, String string, int n) {
        this(plotter, string, n, string);
    }

    public DesenhoFuncao(Plotter plotter, String string, int n, String string2) {
        super(plotter, n);
        if (string != null) {
            string = string.trim();
        }
        this.funcaoOriginal = string;
        this.funcaoAtual = string;
        this.setDescricao(this.functionID + "(x) = " + string2);
    }

    protected String getFunctionName() {
        return this.functionID;
    }

    public void setDominio(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(93);
        if (n == -1) {
            return;
        }
        int n2 = string.indexOf(44);
        try {
            String string2 = string.substring(1, n2).trim();
            String string3 = string.substring(n2 + 1, n).trim();
            if (string2.length() == 0) {
                this.intervalMinimumScale = this.getXMin() / this.getEscala();
                this.aIndefinido = true;
            } else {
                this.intervalMinimumScale = Double.valueOf(string2);
            }
            if (string3.length() == 0) {
                this.intervalMaximumScale = this.getXMax() / this.getEscala();
                this.bIndefinido = true;
            } else {
                this.intervalMaximumScale = Double.valueOf(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        this.dominioDefinido = true;
        this.dominio = string;
    }

    public void atualizaDesenho(Graphics2D graphics2D) {
        Polygon polygon = null;
        if (this.dominioDefinido) {
            this.intervalMinimumInt = this.aIndefinido ? this.getXMin() : (int)(this.intervalMinimumScale * (double)this.getEscala());
            this.intervalMaximumInt = this.bIndefinido ? this.getXMax() : (int)(this.intervalMaximumScale * (double)this.getEscala());
            polygon = GeraPoligono.getGrafico(this.funcaoAtual, this.intervalMinimumInt, this.intervalMaximumInt, this.getEscala());
        } else {
            polygon = GeraPoligono.getGrafico(this.funcaoAtual, this.getXMin(), this.getXMax(), this.getEscala());
        }
        if (polygon == null) {
            return;
        }
        this.polygonToBeDrawn = polygon;
        this.renderiza(this.polygonToBeDrawn, graphics2D);
    }

    public boolean editaGrafico(String string, Color color) {
        try {
            this.setColor(color);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "";
        if (string2 != null & string2.length() > 0 & !string2.equals(this.funcaoAtual)) {
            this.funcaoAtual = string2;
            return true;
        }
        return string2.equals(this.funcaoAtual) & this.dominioDefinido;
    }

    public String getFuncaoAtual() {
        return this.funcaoAtual;
    }

    public String getFuncaoOriginal() {
        return this.funcaoOriginal;
    }

    public String toString() {
        if (this.dominio.length() == 0) {
            return this.funcaoAtual;
        }
        return this.funcaoAtual + "  " + this.dominio;
    }

    public void mudaFuncao(String string) {
        this.funcaoAtual = string;
        this.setDescricao(this.functionID + "(x) = " + this.funcaoAtual);
    }
}

