/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.basico.io.ResourceReader;
import igraf.basico.util.GeraPoligono;
import igraf.moduloCentral.visao.desenho.DesenhoFuncao;
import igraf.moduloCentral.visao.plotter.GraphPlotter;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.Color;
import java.awt.Graphics2D;

public class DesenhoAnimacao
extends DesenhoFuncao {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/desenho/DesenhoAnimacao.java";
    public static boolean tracking;
    private boolean animando = false;
    private String funcao_temporaria;
    private String dominio = "";
    private boolean dominioDefinido = false;
    int xa;
    int xb;
    private String string;
    private char[] listaChar = new char[]{'@', '#', '$', '?', '&', '!'};
    private GraphPlotter gp;

    public DesenhoAnimacao(GraphPlotter graphPlotter, String string, int n) {
        super(graphPlotter, string, n);
        this.gp = graphPlotter;
        this.string = string;
        this.funcaoAtual = this.verificaFuncao(string);
        if (this.funcaoAtual != null) {
            this.funcao_temporaria = this.changeSymbol(this.funcaoAtual);
            this.animate(true);
        }
        this.setDescricao(this.getFunctionName() + "(a,x) = " + string);
    }

    public void setFuncaoAtual(String string) {
        this.funcao_temporaria = this.changeSymbol(this.verificaFuncao(string));
    }

    private String verificaFuncao(String string) {
        int n = string.indexOf(91);
        if (n > -1) {
            try {
                this.setDominio(string.substring(n));
            }
            catch (RuntimeException runtimeException) {
                this.dominioDefinido = false;
                this.dominio = "";
                return null;
            }
            string = string.substring(0, n);
        } else {
            this.dominioDefinido = false;
        }
        if (!Analisa.sintaxeCorreta(string)) {
            throw new IllegalArgumentException(ResourceReader.msg("daErroOperador"));
        }
        return Analisa.getResult();
    }

    public boolean editaGrafico(String string, Color color) {
        try {
            this.setColor(color);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = this.verificaFuncao(string);
        if (string2 != null & !string2.equals(this.funcaoAtual)) {
            this.funcaoAtual = string2;
            return true;
        }
        return string2.equals(this.funcaoAtual) & this.dominioDefinido;
    }

    public void animate(boolean bl) {
        this.animando = bl;
    }

    public void mudaEstadoAnimacao() {
        this.animando = !this.animando;
        System.err.println("\nigraf/moduloCentral/visao/desenho/DesenhoAnimacao.java: DesenhoAnimacao.java: mudaEstadoAnimacao(): animando=" + this.animando + " - this melhod is suppossed to be turned off!");
    }

    public void atualizaDesenho(Graphics2D graphics2D) {
        if (this.animando) {
            this.nextDraw();
        }
        this.polygonToBeDrawn = GeraPoligono.getGrafico(this.funcao_temporaria, this.getXMin(), this.getXMax(), this.getEscala());
        this.renderiza(this.polygonToBeDrawn, graphics2D);
    }

    public void nextDraw() {
        this.funcao_temporaria = this.changeSymbol(this.funcaoAtual);
    }

    private String changeSymbol(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = this.lookChar(c);
            if (n == -1) continue;
            string = this.change(string, c, n);
        }
        return string;
    }

    private int lookChar(char c) {
        for (int i = 0; i < this.listaChar.length; ++i) {
            if (this.listaChar[i] != c) continue;
            return i;
        }
        return -1;
    }

    private String change(String string, char c, int n) {
        switch (n) {
            case 0: {
                string = this.replaceAll(string, c, this.gp.getValorA());
                break;
            }
            case 1: {
                string = this.replaceAll(string, c, this.gp.getValorB());
                break;
            }
            case 2: {
                string = this.replaceAll(string, c, this.gp.getValorC());
                break;
            }
            case 3: {
                string = this.replaceAll(string, c, this.gp.getValorK());
                break;
            }
            case 4: {
                string = this.replaceAll(string, c, this.gp.getValorM());
                break;
            }
            case 5: {
                string = this.replaceAll(string, c, this.gp.getValorN());
            }
        }
        return string;
    }

    private String replaceAll(String string, char c, double d) {
        String string2 = "(" + new Double(d).toString() + ")";
        while (string.indexOf(c) != -1) {
            int n = string.indexOf(c);
            int n2 = n + 1;
            string = string.substring(0, n) + string2 + string.substring(n2, string.length());
        }
        return string;
    }

    public String getFuncaoAtual() {
        return this.string;
    }

    public void mudaFuncao(String string) {
        this.string = string;
        this.funcaoAtual = this.verificaFuncao(string);
        this.setDescricao("f(a,x) = " + string);
    }

    public String toString() {
        return this.string;
    }
}

