/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle;

import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.basico.event.ChangeLanguageEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.ModuloCentral;
import igraf.moduloCentral.eventos.FrameResizedEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloCentral.eventos.menu.IgrafSubMenuEvent;
import igraf.moduloCentral.visao.PainelCentral;
import igraf.moduloCentral.visao.menu.IgrafMenu;
import igraf.moduloSuperior.eventos.IgrafButtonPaneEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class PainelCentralController
extends CommunicationController
implements MouseMotionListener {
    private PainelCentral componentPanelCentral;
    private ModuloCentral componentModuloCentral;

    public void setControlledObject(Object object) {
        this.componentPanelCentral = (PainelCentral)object;
    }

    public PainelCentralController(ModuloCentral moduloCentral, boolean bl) {
        super(moduloCentral, bl);
        this.componentModuloCentral = moduloCentral;
    }

    public ModuloCentral getMc() {
        return this.componentModuloCentral;
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        if (communicationEvent instanceof ChangeLanguageEvent) {
            this.componentPanelCentral.updateLabels();
            return;
        }
        if (communicationEvent instanceof FrameResizedEvent) {
            this.componentPanelCentral.setTabbedViewerBounds(communicationEvent);
        } else if (communicationEvent instanceof IgrafButtonPaneEvent || communicationEvent instanceof IgrafSubMenuEvent) {
            this.alteraVisualizacaoMenu(communicationEvent);
        }
        String string = communicationEvent.getCommand();
        if (string.equals(ResourceReader.msg("maMostraCDesl"))) {
            this.componentPanelCentral.mudaExibicaoSlider();
        } else if (string.equals(ResourceReader.msg("msgMenuGrfNovaAba"))) {
            this.componentPanelCentral.insereAba();
            if (((IgrafMenuGraficoEvent)communicationEvent).isLoading()) {
                this.componentPanelCentral.nextTab();
            }
        } else if (string.equals(ResourceReader.msg("msgMenuGrfRemoverAba"))) {
            this.componentPanelCentral.removeAba();
        } else if (string.equals(ResourceReader.msg("arqMenuCopia"))) {
            this.componentPanelCentral.copiarImagem();
        } else if (string.equals(ResourceReader.msg("arqMenuExporta"))) {
            this.componentPanelCentral.exportarJPG();
        }
    }

    private void alteraVisualizacaoMenu(CommunicationEvent communicationEvent) {
        IgrafMenu igrafMenu = null;
        igrafMenu = this.getMenu(communicationEvent.getCommand());
        int n = communicationEvent.getEventType();
        if (n == 2) {
            this.componentPanelCentral.exibeMenu(igrafMenu, communicationEvent.getX() + 2);
        }
        if (n == 3) {
            this.componentPanelCentral.removeMenu(igrafMenu);
        }
    }

    private IgrafMenu getMenu(String string) {
        IgrafMenu[] igrafMenuArray = this.componentPanelCentral.getMenuList();
        for (int i = 0; i < igrafMenuArray.length; ++i) {
            IgrafMenu igrafMenu = igrafMenuArray[i];
            if (!igrafMenu.toString().equals(string)) continue;
            return igrafMenu;
        }
        return null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.componentPanelCentral.removeMenuAtual();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

