/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloArquivo;

import igraf.IGraf;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Configuracoes;
import igraf.moduloArquivo.FileFilterIGraf;
import igraf.moduloArquivo.Sistema;
import igraf.moduloArquivo.controle.ArquivoController;
import igraf.moduloArquivo.modelo.ArquivoModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Arquivo {
    public static final String IGCLASSPATH = "igraf/moduloArquivo/Arquivo.java";
    private static String errorLog = "";
    private ArquivoModel arquivoModel = new ArquivoModel();
    private static final String IGRAF = "iGraf.jar";
    private JFileChooser fileChooser = null;
    private String nomeArquivo = null;
    private String currentPath = "";
    private JFrame frame = new JFrame(".: iGraf: www.matematica.br/igraf :.");

    public static void addLogError(String string, String string2) {
        errorLog = errorLog + "[" + string + " :: " + string2 + "], ";
    }

    public Arquivo(ArquivoController arquivoController) {
        String string = "";
        if (IGraf.ehApplet) {
            string = IGraf.getInstanceIGraf().getCodeBase() + "";
        } else {
            string = System.getProperty("user.dir");
            this.fileChooser = new JFileChooser(string);
        }
        this.currentPath = string;
    }

    public ArquivoModel getModel() {
        return this.arquivoModel;
    }

    public boolean gravarGrafico() {
        if (this.naoGravado()) {
            return this.gravarComo(ResourceReader.msg("msgTipoArq"));
        }
        this.registerCurrentTabContent();
        return true;
    }

    public boolean gravarComo(String string) {
        String[] stringArray = new String[]{string};
        String string2 = ResourceReader.msgComVar("msgGravarTipoArq", "OBJ", stringArray);
        this.nomeArquivo = this.dialogNomeArquivo("grf", string, string2);
        if (this.nomeArquivo == null) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "File " + this.nomeArquivo);
            return false;
        }
        System.out.println("src/igraf/moduloArquivo/Arquivo.java: gravarComo(" + string + "): nomeArquivo=" + this.nomeArquivo);
        if (this.nomeArquivo != null && !this.nomeArquivo.equalsIgnoreCase("null")) {
            this.registerCurrentTabContent();
            return true;
        }
        this.nomeArquivo = null;
        return false;
    }

    private String dialogNomeArquivo(String string, String string2, String string3) {
        Object object;
        String string4 = "iGraf - " + string3;
        this.fileChooser.setDialogType(1);
        this.fileChooser.setFileSelectionMode(2);
        FileFilterIGraf fileFilterIGraf = Sistema.getFileFilterIGraf(string, new String[]{string});
        this.fileChooser.addChoosableFileFilter(fileFilterIGraf);
        int n = this.fileChooser.showDialog(this.frame, string4);
        if (n == 1 || n == -1) {
            if (n == -1) {
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: something wrong with file choosen!");
            } else {
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Register canceled!");
            }
            return null;
        }
        if (n == 0) {
            object = this.fileChooser.getSelectedFile();
            this.nomeArquivo = this.fileChooser.getName((File)object);
        }
        object = this.verificaExtensao(this.nomeArquivo, string);
        return this.currentPath + "/" + (String)object;
    }

    public void gerarHTML() {
        this.nomeArquivo = this.dialogNomeArquivo("html", "HTML", ResourceReader.msg("msgExportaPagWeb"));
        System.out.println("src/igraf/moduloArquivo/Arquivo.java: gerarHTML(): nomeArquivo=" + this.nomeArquivo);
        this.gravarHTML();
    }

    private void gravarHTML() {
        String string = this.cabecalhoHTML() + this.codigoApplet() + this.rodapeHTML();
        try {
            Sistema.gravar(this.nomeArquivo, string, ResourceReader.msg("arquivo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String verificaExtensao(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = string.substring(n + 1);
        if (n > 0 && string3.equals(string2)) {
            return string;
        }
        if (n == -1 && string.length() > 0) {
            return string + "." + string2;
        }
        System.err.println("Error: this is an invalid iGraf file name! I will use 'ArquivoDoIGraf." + string2 + "'");
        return "ArquivoDoIGraf." + string2;
    }

    public String constroiArquivo() {
        return Arquivo.cabecalho() + "\r\n" + this.arquivoModel.getListaSessaoAsString();
    }

    private void registerCurrentTabContent() {
        String string = this.constroiArquivo();
        try {
            Sistema.gravar(this.nomeArquivo, string, "Arquivo");
        }
        catch (Exception exception) {
            System.err.println("Error: when I try to save the file under the name '" + this.nomeArquivo + "'");
            exception.printStackTrace();
        }
    }

    private void selecionaArquivo() {
        Object object;
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setDialogTitle("grf");
        FileFilterIGraf fileFilterIGraf = Sistema.getFileFilterIGraf("grf", new String[]{"grf"});
        this.fileChooser.addChoosableFileFilter(fileFilterIGraf);
        int n = this.fileChooser.showDialog(this.frame, ResourceReader.msg("msgCarga"));
        if (n == 1 || n == -1) {
            if (n == -1) {
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: something wrong with open file choosen!");
            } else {
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Open canceled!");
            }
            return;
        }
        if (n == 0) {
            object = this.fileChooser.getSelectedFile();
            this.nomeArquivo = this.fileChooser.getName((File)object);
        }
        object = this.verificaExtensao(this.nomeArquivo, "grf");
    }

    public void loadFile() {
        this.selecionaArquivo();
        if (this.nomeArquivo != null) {
            this.arquivoModel.reset();
            this.arquivoModel.refazSessao(Sistema.readFileFromHD(this.nomeArquivo, ResourceReader.msg("msgAbrirArq")));
            this.arquivoModel.sessionChanged(false);
        }
    }

    public boolean naoGravado() {
        return this.nomeArquivo == null;
    }

    public int desejaGravarAlteracao() {
        return JOptionPane.showConfirmDialog(null, ResourceReader.msg("msgDesejaGravarSes"), ResourceReader.msg("msgGravarSes"), 1, 3);
    }

    public void reset() {
        this.nomeArquivo = null;
    }

    private void copiaArquivoJarPara(String string) {
        File file = new File(IGRAF);
        File file2 = new File(string + IGRAF);
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean existeIgrafJar(String string) {
        File file = new File(string);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(IGRAF)) continue;
            return true;
        }
        return false;
    }

    public static String cabecalho() {
        String string = "<applet>";
        if (!IGraf.ehApplet) {
            try {
                string = System.getProperty("user.name");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string2 = "";
        String string3 = "";
        string2 = "# iGraf: http://www.matematica.br\r\n# iGraf: version " + Configuracoes.getVersion() + "\r\n" + string3 + "# unicodeblock: " + Sistema.UNICODE + "\r\n" + "# user: " + string + "\r\n" + "# last modified: " + new Date().toString() + "\r\n";
        if (errorLog != null && errorLog != "") {
            string2 = string2 + "# log: " + errorLog + "\r\n";
        }
        return string2;
    }

    private String cabecalhoHTML() {
        String string = "<html>\r\n<head>\r\n <title>.: iGraf :: " + ResourceReader.msg("igraf") + " :.</title>\r\n" + "</head>\r\n\r\n" + "<body>\r\n" + " <h1>" + ResourceReader.msg("igraf") + "</h1><br/>\r\n" + " <b>" + ResourceReader.msg("msgAFmsg6") + "</b><br/>\r\n" + " <a href=\"http://www.matematica.br/igraf\" title=\"iGraf home page\">iGraf : http://www.matematica.br/igraf</a><br/>\r\n\r\n";
        return "<!-- \r\n" + Arquivo.cabecalho() + "\r\n-->\r\n" + string;
    }

    private String codigoApplet() {
        String string = " <p align = \"center\">\r\n <applet codebase=\".\" code=\"igraf.IGraf.class\" archive=\"iGraf.jar\" width=832 height=564>\r\n  <param name=\"lang\" value=\"pt\"> <!-- in order to use iGraf with English version, change 'pt' to 'en' -->\r\n  <param name=\"MA_PARAM_Proposition\" value=\"" + this.arquivoModel.getListaSessaoAsString() + "\">\r\n" + " </applet></p>\r\n";
        return string;
    }

    private String rodapeHTML() {
        String string = "<p align = \"left\">\r\n<hr size=1\\> <h2><a href=\"http://www.matematica.br/igraf\" title=\"clique aqui para ir para a p\u00e1gina oficial do iGraf\" style = \"text-decoration: none\"> Confira a \u00faltima vers\u00e3o do iGraf</a></h2>\r\n\r\n <p>\r\n <font face=\"Arial, Helvetica, sans-serif\" size=1>&nbsp;P\u00e1gina gerada automaticamente pelo\r\n <a href=\"http://www.matematica.br/igraf\">iGraf</a><br>\r\n &nbsp;Coordena\u00e7\u00e3o/Desenvolvimento:  Prof. Dr. <a href=\"http://www.ime.usp.br/~leo\"> Le\u00f4nidas O. Brand\u00e3o</a><br> \r\n &nbsp;Desenvolvimento: Prof. Ms. <a href=\"http://www.ime.usp.br/~rprado\">Reginaldo do Prado</a></font><br> <hr noshade size=1\\>\r\n <table border=\"0\" width=\"100%\">\r\n  <tr><td align=\"left\">\r\n    <font face=\"Arial, Helvetica, sans-serif\" size=\"-1\">\r\n    <a href=\"http://www.ime.usp.br\">Instituto de Matem\u00e1tica e Estat\u00edstica</a><br>\r\n    <a href=\"http://www.usp.br\">Universidade de S\u00e3o Paulo</a></font></td>\r\n <td align=\"right\"><font face=\"Arial, Helvetica, sans-serif\" size=\"-1\">    <a href=\"http://www.matematica.br\">iM\u00e1tica</a> <br>\r\n    Mate<i>m\u00e1tica</i> <i>I</i>nterativa </td></tr> </table>\r\n</font>\r\n</body>\r\n</html>\r\n";
        return string;
    }
}

