/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloAjuda.visao.navegador;

import igraf.basico.io.ResourceReader;
import igraf.moduloAjuda.eventos.NavigatorPanelEvent;
import igraf.moduloAjuda.modelo.JPanelBasisTopic;
import igraf.moduloAjuda.modelo.ListaTextoAjuda;
import igraf.moduloAjuda.visao.navegador.HelpButton;
import igraf.moduloAjuda.visao.navegador.NavigatorPanel;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class LinearNavigator
extends NavigatorPanel
implements ActionListener {
    private HelpButton buttonVoltar;
    private HelpButton buttonAvancar;
    private HelpButton buttonInicial;
    private HelpButton buttonImprimir;

    public LinearNavigator() {
        this.setLayout(new FlowLayout(0));
        this.buttonVoltar = new HelpButton(ResourceReader.msg("manualTopPback"));
        this.buttonAvancar = new HelpButton(ResourceReader.msg("manualTopPforw"));
        this.buttonInicial = new HelpButton(ResourceReader.msg("manualTopPstar"));
        this.buttonImprimir = new HelpButton(ResourceReader.msg("manualTopPprint"));
        this.buttonVoltar.addActionListener(this);
        this.buttonAvancar.addActionListener(this);
        this.buttonInicial.addActionListener(this);
        this.buttonImprimir.addActionListener(this);
        this.buttonVoltar.setEnabled(false);
        this.buttonInicial.setEnabled(false);
        this.add(this.buttonVoltar);
        this.add(this.buttonAvancar);
        this.add(this.buttonInicial);
        this.add(this.buttonImprimir);
        this.setConteudoAjuda(0);
    }

    private void disableApropriatedButton(int n) {
        if (n == 0) {
            this.buttonVoltar.setEnabled(false);
            this.buttonInicial.setEnabled(false);
            this.buttonAvancar.setEnabled(true);
        } else if (n == ListaTextoAjuda.numTopicos - 1) {
            this.buttonAvancar.setEnabled(false);
            this.buttonVoltar.setEnabled(true);
            this.buttonInicial.setEnabled(true);
        } else {
            this.buttonVoltar.setEnabled(true);
            this.buttonInicial.setEnabled(true);
            this.buttonAvancar.setEnabled(true);
        }
    }

    private void imprimir() {
        JFrame jFrame = new JFrame();
        JPanelBasisTopic jPanelBasisTopic = this.getConteudoSelecionado();
        PrintJob printJob = this.getToolkit().getPrintJob(jFrame, jPanelBasisTopic.toString(), null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                jPanelBasisTopic.printAll(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ResourceReader.msg("manualTopPback"))) {
            this.setConteudoAjuda(--this.textIndex);
        } else if (string.equals(ResourceReader.msg("manualTopPforw"))) {
            this.setConteudoAjuda(++this.textIndex);
        } else if (string.equals(ResourceReader.msg("manualTopPstar"))) {
            this.textIndex = 0;
            this.setConteudoAjuda(0);
        } else if (string.equals(ResourceReader.msg("manualTopPprint"))) {
            this.imprimir();
        }
        this.disableApropriatedButton(this.textIndex);
    }

    public void mudouItemSelecionado(NavigatorPanelEvent navigatorPanelEvent) {
        this.textIndex = navigatorPanelEvent.getSelectedTextIndex();
        this.disableApropriatedButton(this.textIndex);
    }

    public void updateLabels() {
        this.buttonVoltar.setText(ResourceReader.msg("manualTopPback"));
        this.buttonAvancar.setText(ResourceReader.msg("manualTopPforw"));
        this.buttonInicial.setText(ResourceReader.msg("manualTopPstar"));
        this.buttonImprimir.setText(ResourceReader.msg("manualTopPprint"));
    }
}

