/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloAjuda.modelo;

import igraf.IGraf;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloAjuda.visao.componentesDoTexto.Paragrafo;
import igraf.moduloAjuda.visao.componentesDoTexto.Topico;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class JPanelBasisTopic
extends JPanel {
    public static final String IGCLASSPATH = "igraf/moduloAjuda/modelo/JPanelBasisTopic.java";
    private static final int TOPICHEIGHT = 30;
    private static final int TOPICWIDTH = 620;
    private int altura = 45;
    private final Dimension dimension = new Dimension(620, this.altura);
    private String rootNameOfTopic;
    private Topico titleTopic;
    private static HashMap hashMapOfItems = new HashMap();

    public JPanelBasisTopic(String string) {
        this.setLayout(new FlowLayout(0, 0, 4));
        this.setTitulo(string);
        this.setBackground(EsquemaVisual.corFundoParagrafos);
    }

    private void setTitulo(String string) {
        this.titleTopic = this.insereTopico(string, 0);
        this.rootNameOfTopic = string;
    }

    public String getRootNameOfTopic() {
        return this.rootNameOfTopic;
    }

    void insereSessao(String string) {
        this.insereTopico(string, 2);
    }

    private Topico insereTopico(String string, int n) {
        Topico topico = null;
        try {
            topico = new Topico(string, n, 620);
            try {
                this.atualizaAltura(topico.getAltura());
            }
            catch (IllegalAccessError illegalAccessError) {
                System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Erro: " + illegalAccessError + "\nAcesso ilegal: rootTopicName=" + string + " nivel=" + n + " topico=" + topico);
            }
            this.add(topico);
        }
        catch (Exception exception) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "[insereTopico] Erro: " + exception + "\nrootTopicName=" + string + " nivel=" + n + " topico=" + topico);
        }
        hashMapOfItems.put(string, topico);
        topico.setPreferredSize(new Dimension(620, 30));
        return topico;
    }

    void insereSubTitulo(String string) {
        this.insereTopico(string, 1);
    }

    void insereParagrafo(String string) {
        Paragrafo paragrafo = new Paragrafo(string, 620);
        this.atualizaAltura(paragrafo.getAltura());
        hashMapOfItems.put(string, paragrafo);
        this.add(paragrafo);
    }

    boolean insereFigura(String string) {
        return false;
    }

    private void atualizaAltura(int n) {
        this.dimension.setSize(620, this.altura += n + 10);
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public Insets getInsets() {
        return new Insets(0, 4, 4, 4);
    }

    public String toString() {
        return this.rootNameOfTopic;
    }

    public static void updateLabels() {
        Topico topico = null;
        int n = 0;
        Iterator iterator = hashMapOfItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Topico) {
                topico = (Topico)v;
                topico.setText(ResourceReader.msg(string));
            } else if (v instanceof Paragrafo) {
                Paragrafo paragrafo = (Paragrafo)v;
                paragrafo.setText(ResourceReader.msg(string));
            }
            ++n;
        }
    }
}

