/*
 * Decompiled with CFR 0.152.
 */
package igraf.basico.util;

import igraf.basico.util.Funcao;
import igraf.basico.util.Utilitarios;
import java.util.Vector;

public class Calculo {
    static double parteNegativaIntegral;
    static double partePositivaIntegral;
    static double dx;
    private static Vector listaNegativa;
    private static Vector listaPositiva;

    public static double integralDefinida(String string, double d, double d2) {
        Calculo.reset();
        int n = 400;
        dx = (d2 - d) / (double)n;
        double d3 = 0.0;
        Funcao funcao = new Funcao(1);
        if (!funcao.constroiExpressao(string)) {
            System.err.println("Erro: em calculo de funcao " + string + ": incorreta");
            return 0.0;
        }
        double d4 = funcao.f(d);
        Calculo.acumula(d4);
        for (int i = 1; i < n; ++i) {
            d3 += Calculo.acumula(funcao.f(d += dx));
        }
        double d5 = funcao.f(d2);
        Calculo.acumula(d5);
        return dx / 2.0 * (d4 + d5 + 2.0 * d3);
    }

    private static double acumula(double d) {
        if (d < 0.0) {
            listaNegativa.addElement(new Double(d));
        } else {
            listaPositiva.addElement(new Double(d));
        }
        return d;
    }

    public static double getParteNegativaIntegral() {
        try {
            parteNegativaIntegral += ((Double)listaNegativa.elementAt(0)).doubleValue();
            parteNegativaIntegral += ((Double)listaNegativa.lastElement()).doubleValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0.0;
        }
        for (int i = 1; i < listaNegativa.size() - 1; ++i) {
            parteNegativaIntegral += 2.0 * (Double)listaNegativa.elementAt(i);
        }
        return dx * parteNegativaIntegral / 2.0;
    }

    public static double getPartePositivaIntegral() {
        try {
            partePositivaIntegral += ((Double)listaPositiva.elementAt(0)).doubleValue();
            partePositivaIntegral += ((Double)listaPositiva.lastElement()).doubleValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0.0;
        }
        for (int i = 1; i < listaPositiva.size() - 1; ++i) {
            partePositivaIntegral += 2.0 * (Double)listaPositiva.elementAt(i);
        }
        return dx * partePositivaIntegral / 2.0;
    }

    private static void reset() {
        parteNegativaIntegral = 0.0;
        partePositivaIntegral = 0.0;
        listaNegativa = new Vector(100);
        listaPositiva = new Vector(100);
    }

    public static void mainD(String[] stringArray) {
        double d = Calculo.integralDefinida("cos(x)", -1.57, 1.57);
        String string = Utilitarios.precisao(d);
        System.out.println("parte positiva: " + Utilitarios.precisao(Calculo.getPartePositivaIntegral()));
        System.out.println("parte negativa: " + Utilitarios.precisao(Calculo.getParteNegativaIntegral()));
        System.out.println("int [0..1] = " + string);
    }
}

