/*
 * Decompiled with CFR 0.152.
 */
package igraf.basico.img;

import igraf.basico.img.ImageSelection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class SaidaImagem {
    public static void copiarImagem(Component component) {
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        component.paint(graphics2D);
        graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        ImageSelection imageSelection = new ImageSelection(bufferedImage);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public static void salvarComoJPEG(Component component) {
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        component.paint(graphics2D);
        graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        try {
            File file = new File(SaidaImagem.getFileName());
            ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Houve um erro ao salvar imagem JPEG.", "ERRO", 0);
        }
    }

    private static String getFileName() {
        int n;
        String string = null;
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame);
        fileDialog.setMode(1);
        fileDialog.setTitle("Salvar como imagem JPG");
        fileDialog.setVisible(true);
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            string = fileDialog.getDirectory() + fileDialog.getFile();
        }
        if (!string.substring((n = string.length()) - 4, n).equals(".jpg")) {
            string = string + ".jpg";
        }
        return string;
    }
}

