/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao;

import igraf.basico.event.AttentionToolTip;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Crypto;
import igraf.moduloExercicio.visao.JanelaExercicio;
import igraf.moduloExercicio.visao.PainelResposta;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PainelRespostaNumerica
extends PainelResposta {
    protected JTextField textFieldEnterExpression;
    protected JPanel panel;
    protected String respostaAluno;
    protected String respostaGabarito;

    public PainelRespostaNumerica(JanelaExercicio janelaExercicio) {
        this.janelaExercicio = janelaExercicio;
        this.configurePanelAtRight();
        this.setLabelText(ResourceReader.msg("exercRNdigR"));
    }

    public PainelRespostaNumerica(JanelaExercicio janelaExercicio, int n) {
        this(janelaExercicio);
        this.setNumeroResposta(n);
    }

    public PainelRespostaNumerica(JanelaExercicio janelaExercicio, String string, int n) {
        this.janelaExercicio = janelaExercicio;
        this.setLabelText(ResourceReader.msg("exercRNdigR"));
        this.respostaGabarito = string;
        this.configurePanelAtRight();
        this.setNumeroResposta(n);
    }

    protected void configurePanelAtRight() {
        this.textFieldEnterExpression = new JTextField();
        this.panel = new JPanel(new GridLayout(3, 1));
        this.adicionaConteudoDireito(this.textFieldEnterExpression);
    }

    public void limparCampos() {
        try {
            this.textFieldEnterExpression.setText("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getResposta() {
        return super.getResposta() + "val:" + Crypto.stringToHex(this.textFieldEnterExpression.getText()) + " ";
    }

    public boolean validar() {
        if (this.textFieldEnterExpression == null) {
            String[] stringArray = new String[]{"" + this.numQuest};
            String string = ResourceReader.msgComVar("exercRNerrDebug1", "OBJ", stringArray);
            this.janelaExercicio.setMessage(string);
            AttentionToolTip.showToolTipText(this, string);
            return false;
        }
        String string = this.textFieldEnterExpression.getText();
        if (string == null || string == "" || string.length() == 0) {
            String[] stringArray = new String[]{"" + this.numQuest};
            String string2 = ResourceReader.msgComVar("exercRNerrNN", "OBJ", stringArray) + ". " + ResourceReader.msg("exercRNerrEmpt");
            this.indicaCampoComErro(this.textFieldEnterExpression);
            this.janelaExercicio.setMessage(string2);
            AttentionToolTip.showToolTipText(this.textFieldEnterExpression, string2);
            return false;
        }
        if (this.validacaoOk(this.textFieldEnterExpression, true)) {
            this.respostaAluno = string;
            return true;
        }
        return false;
    }

    private double valorGabarito() {
        double d = -1.0;
        try {
            d = Double.parseDouble(this.respostaGabarito);
        }
        catch (Exception exception) {
            System.err.println("PainelRespostaNumerica.valorGabarito(): " + exception.toString());
        }
        return d;
    }

    public double valorResposta() {
        double d = -1.0;
        try {
            d = Double.parseDouble(this.respostaAluno);
        }
        catch (Exception exception) {
            System.err.println("PainelRespostaNumerica.valorResposta(): " + exception.toString());
        }
        return d;
    }

    public int comparaResposta() {
        this.maxNumError = 1;
        if (!this.erroAceitavel(this.valorGabarito(), this.valorResposta())) {
            this.diagnostico = this.diagnostico + this.respostaErrada(this.respostaAluno) + "\r\n";
            this.registraDiagnostico(this.diagnostico);
            ++this.numErros;
        } else {
            this.diagnostico = this.diagnostico + this.respostaCerta(this.respostaAluno) + "\r\n";
            this.registraDiagnostico(this.diagnostico);
            ++this.numAcertos;
        }
        this.setValorCorrecao(this.correcao());
        this.setValorResposta(String.valueOf(this.valorResposta()));
        return this.numErros;
    }

    public void updateLabels() {
        super.updateLabels();
        this.setLabelText(ResourceReader.msg("exercRNdigR"));
    }
}

