/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.plotter;

import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Configuracoes;
import igraf.basico.util.GeraPoligono;
import igraf.basico.util.Utilitarios;
import igraf.moduloCentral.controle.desenho.DesenhoAnimacaoController;
import igraf.moduloCentral.controle.desenho.DesenhoCalculoController;
import igraf.moduloCentral.controle.desenho.DesenhoController;
import igraf.moduloCentral.controle.desenho.DesenhoFuncaoController;
import igraf.moduloCentral.controle.desenho.DesenhoTangenteController;
import igraf.moduloCentral.controle.desenho.DesenhoTextoController;
import igraf.moduloCentral.eventos.DesenhoTextoEvent;
import igraf.moduloCentral.eventos.EstadoTelaEvent;
import igraf.moduloCentral.eventos.GraphPlotterEvent;
import igraf.moduloCentral.eventos.GraphicOnScreenChangedEvent;
import igraf.moduloCentral.eventos.ResetEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloCentral.visao.AreaDesenho;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.desenho.DesenhoAnimacao;
import igraf.moduloCentral.visao.desenho.DesenhoFuncao;
import igraf.moduloCentral.visao.desenho.DesenhoIntegral;
import igraf.moduloCentral.visao.desenho.DesenhoTexto;
import igraf.moduloCentral.visao.plotter.Plotter;
import igraf.moduloInferior.ModuloInferior;
import igraf.moduloJanelasAuxiliares.eventos.AtualizaParametroEvent;
import igraf.moduloJanelasAuxiliares.eventos.EdicaoExpressaoEvent;
import igraf.moduloJanelasAuxiliares.eventos.JanelaTangenteEvent;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;

public class GraphPlotter
extends Plotter {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/plotter/GraphPlotter.java";
    private static final int POSX_LST_FUNCTIONS = 20;
    private static final int POSY_LST_FUNCTIONS = 30;
    private AreaDesenho areaDesenho;
    private Vector listaDesenhoVisivel = new Vector();
    private int strokeIndex = -1;
    private int ordem = 0;
    private Color corFuncao;
    private Desenho desenho;
    private ModuloInferior moduloInferior;
    private DesenhoAnimacaoController desenhoAnimacaoController = new DesenhoAnimacaoController(this);
    private DesenhoTangenteController desenhoTangenteController = new DesenhoTangenteController(this);
    private DesenhoCalculoController desenhoCalculoController = new DesenhoCalculoController(this);
    private DesenhoFuncaoController desenhoFuncaoController = new DesenhoFuncaoController(this);
    private DesenhoTextoController desenhoTextoController = new DesenhoTextoController(this);
    private DesenhoTexto desenhoTexto;
    private DesenhoTextoEvent desenhoTextoEvent;
    private boolean exibirListaFuncao = false;
    private FontMetrics fm;
    private Desenho functionSelected = null;
    private Desenho functionUnderMouse = null;
    private int xFuncao;
    private int yFuncao;
    private int textIndex = -1;

    public GraphPlotter(AreaDesenho areaDesenho, ModuloInferior moduloInferior) {
        this.areaDesenho = areaDesenho;
        this.moduloInferior = moduloInferior;
    }

    public AreaDesenho getAreaDesenho() {
        return this.areaDesenho;
    }

    public void trataCalculoEvent(CommunicationEvent communicationEvent) {
        this.desenhoCalculoController.trataEvento(communicationEvent);
    }

    public void desenha(Graphics2D graphics2D, int n, int n2) {
        super.dimensiona(graphics2D, n, n2);
        this.desenhoAnimacaoController.setValorA();
        this.atualizaDesenho(this.desenhoCalculoController, graphics2D);
        this.atualizaDesenho(this.desenhoFuncaoController, graphics2D);
        this.atualizaDesenho(this.desenhoTangenteController, graphics2D);
        this.atualizaDesenho(this.desenhoAnimacaoController, graphics2D);
        this.atualizaDesenho(this.desenhoTextoController, graphics2D);
        if (this.functionUnderMouse != null) {
            this.desenhaExpressao(graphics2D);
        }
        if (this.exibirListaFuncao) {
            this.desenhaListaFuncao(graphics2D);
        }
    }

    public void insereDesenho(String string, String string2, String string3) {
        if (string.indexOf("integral") == 0) {
            int n = string.indexOf("=");
            String string4 = string.substring(n + 2);
            try {
                DesenhoIntegral desenhoIntegral = new DesenhoIntegral(this, string4, this.ordem++);
                this.desenhoCalculoController.insereDesenho(desenhoIntegral);
                this.listaDesenhoVisivel.add(desenhoIntegral);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (Analisa.temParametro(string)) {
            DesenhoAnimacao desenhoAnimacao = new DesenhoAnimacao(this, string, this.ordem++);
            desenhoAnimacao.setDominio(string3);
            if (this.desenhoAnimacaoController.insereDesenho(desenhoAnimacao)) {
                this.listaDesenhoVisivel.add(desenhoAnimacao);
                this.notifyScreenChanged();
            }
            return;
        }
        this.desenho = string2.length() == 0 ? new DesenhoFuncao(this, string, this.ordem++) : new DesenhoFuncao(this, string, this.ordem++, string2);
        this.desenho.setDominio(string3);
        if (this.desenhoFuncaoController.insereDesenho(this.desenho)) {
            this.listaDesenhoVisivel.add(this.desenho);
            this.notifyScreenChanged();
        }
    }

    private void atualizaDesenho(DesenhoController desenhoController, Graphics2D graphics2D) {
        int n = -1;
        try {
            for (n = 0; n < desenhoController.getNumDesenhos(); ++n) {
                this.desenho = desenhoController.getDesenho(n);
                this.desenho.atualizaDesenho(graphics2D);
            }
        }
        catch (Exception exception) {
            String string = "";
            string = "igraf/moduloCentral/visao/plotter/GraphPlotter.java: ";
            System.err.println(string + "Error: in graph plotter, with i=" + n + ", desenho=" + this.desenho);
            exception.printStackTrace();
        }
    }

    private void desenhaListaFuncao(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setFont(Configuracoes.fontFunctionName);
        for (int i = 0; i < this.listaDesenhoVisivel.size(); ++i) {
            Desenho desenho = (Desenho)this.listaDesenhoVisivel.get(i);
            if (desenho == null) continue;
            graphics2D.setColor(desenho.getColor());
            graphics2D.drawString(desenho.getDescricao(), 20, 30 + 20 * i);
        }
        graphics2D.setColor(color);
    }

    public void alternaVisibilidadeListaFuncao() {
        this.exibirListaFuncao = !this.exibirListaFuncao;
    }

    private void desenhaExpressao(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setFont(Configuracoes.fontFunctionName);
        graphics2D.setColor(this.corFuncao);
        graphics2D.drawString(this.functionUnderMouse.getDescricao(), this.xFuncao + 20, this.yFuncao + 10);
        graphics2D.setColor(color);
    }

    public void trataMenuGraficoEvent(IgrafMenuGraficoEvent igrafMenuGraficoEvent) {
        int n = 0;
        String string = igrafMenuGraficoEvent.getCommand();
        if (string.equals(ResourceReader.msg("msgMenuGrfEsconder"))) {
            String string2 = igrafMenuGraficoEvent.getExpressao();
            if (string2.length() > 0) {
                this.apagaGrafico(string2);
            }
        } else if (string.equals(ResourceReader.msg("msgMenuGrfRemoverGrafico"))) {
            this.removeGrafico(igrafMenuGraficoEvent.getExpressao());
        } else if (string.equals(ResourceReader.msg("msgMenuGrfDesTodos"))) {
            this.desenharTodos();
        } else if (string.equals(ResourceReader.msg("msgMenuGrfEsconderUlt"))) {
            this.ocultaUltimoGrafico();
        } else if (string.equals(ResourceReader.msg("msgMenuGrfEsconderTodos"))) {
            this.esconderTodosGraficos();
        } else if (string.equals(ResourceReader.msg("msgMenuGrfRemoverTodos"))) {
            this.removerTodos();
        } else if (string.equals(ResourceReader.msg("msgMenuGrfNovaSes"))) {
            this.enviarEvento(new ResetEvent(this, "reset tab"));
        }
        if (n == IgrafMenuGraficoEvent.id) {
            return;
        }
        n = IgrafMenuGraficoEvent.id;
        if (string.equals(ResourceReader.msg("msgMenuGrfExibeListaExp"))) {
            this.alternaVisibilidadeListaFuncao();
            return;
        }
        this.notifyScreenChanged();
    }

    private void removerTodos() {
        this.listaDesenhoVisivel.removeAllElements();
        this.desenhoFuncaoController.removerTodos();
        this.desenhoAnimacaoController.removerAnimacoes();
        this.desenhoCalculoController.removerIntegrais();
    }

    private void esconderTodosGraficos() {
        this.listaDesenhoVisivel.removeAllElements();
        this.desenhoFuncaoController.ocultaTodosGraficos();
        this.desenhoAnimacaoController.apagaTodasAnimacoes();
        this.desenhoCalculoController.apagaTodasIntegrais();
    }

    private void ocultaUltimoGrafico() {
        try {
            Desenho desenho = (Desenho)this.listaDesenhoVisivel.remove(this.listaDesenhoVisivel.size() - 1);
            if (desenho instanceof DesenhoAnimacao) {
                this.desenhoAnimacaoController.ocultaAnimacao(desenho);
                return;
            }
            if (desenho instanceof DesenhoIntegral) {
                this.desenhoCalculoController.apagaDesenho(desenho);
                return;
            }
            if (desenho instanceof DesenhoFuncao) {
                this.desenhoFuncaoController.ocultaDesenho(desenho);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void desenharTodos() {
        this.listaDesenhoVisivel.removeAllElements();
        this.listaDesenhoVisivel.addAll(this.desenhoFuncaoController.getListaDesenhoOculto());
        this.listaDesenhoVisivel.addAll(this.desenhoAnimacaoController.getListaAnimacaoOculta());
        this.listaDesenhoVisivel.addAll(this.desenhoCalculoController.getListaIntegralOculta());
        Collections.sort(this.listaDesenhoVisivel);
        this.desenhoFuncaoController.desenharTodos();
        this.desenhoCalculoController.desenharTodasIntegrais();
        this.desenhoAnimacaoController.desenharTodasAnimacoes();
    }

    private void apagaGrafico(String string) {
        string = Utilitarios.retiraEspacos(string);
        for (int i = 0; i < this.listaDesenhoVisivel.size(); ++i) {
            Desenho desenho = (Desenho)this.listaDesenhoVisivel.elementAt(i);
            String string2 = Utilitarios.retiraEspacos(desenho.toString());
            if (!string.equals(string2)) continue;
            this.listaDesenhoVisivel.removeElementAt(i);
            if (desenho instanceof DesenhoAnimacao) {
                this.desenhoAnimacaoController.ocultaAnimacao(desenho);
                return;
            }
            if (!(this.desenho instanceof DesenhoFuncao)) continue;
            this.desenhoFuncaoController.ocultaDesenho(desenho);
            this.desenhoTangenteController.removeTangente(string);
            return;
        }
    }

    private void removeGrafico(String string) {
        string = Utilitarios.retiraEspacos(string);
        if (this.functionSelected == null) {
            this.moduloInferior.setStatusBarMessage(ResourceReader.msg("sbSelectedFunctionNull"));
            return;
        }
        int n = this.listaDesenhoVisivel.indexOf(this.functionSelected);
        if (n > -1) {
            this.listaDesenhoVisivel.removeElementAt(n);
            if (this.functionSelected instanceof DesenhoAnimacao) {
                this.desenhoAnimacaoController.removeAnimacao(this.functionSelected);
                this.functionSelected = null;
                this.moduloInferior.setDefaultInfo();
                return;
            }
            if (this.functionSelected instanceof DesenhoFuncao) {
                String string2 = Utilitarios.retiraEspacos(this.functionSelected.getFuncaoAtual());
                this.desenhoFuncaoController.removeDesenho(this.functionSelected);
                this.desenhoTangenteController.removeTangente(string2);
                this.functionSelected = null;
                this.moduloInferior.setDefaultInfo();
                return;
            }
        }
    }

    public void desenhaIntegralIndefinida(String string) {
        if (string == "") {
            Vector vector = this.getListaFuncaoVisivel();
            String string2 = "";
            if (vector != null) {
                int n = vector.size();
                DesenhoFuncao desenhoFuncao = (DesenhoFuncao)vector.elementAt(n - 1);
                string2 = desenhoFuncao.toString();
            }
            string = string2;
        }
        if (string.length() > 0) {
            this.insereDesenho("integral de f(x) = " + string, "", "");
        }
    }

    public void desenhaDerivada(String string) {
        String string2 = GeraPoligono.getDerivada(string);
        this.insereDesenho(string2, new String("h(x) = " + string2 + " derivada de f(x) = " + string), "");
    }

    public void trataDesenhoIntegral(CommunicationEvent communicationEvent) {
        this.desenhoCalculoController.trataEvento(communicationEvent);
    }

    public void iniciaAnimacao(boolean bl) {
        this.adc.iniciaAnimacao(bl);
    }

    public void resetPlotter() {
        this.desenhoAnimacaoController.reset();
        this.desenhoCalculoController.reset();
        this.desenhoFuncaoController.reset();
        this.desenhoTangenteController.reset();
        this.desenhoTextoController.reset();
        this.ordem = 0;
        this.textIndex = -1;
        this.mudaEstadoTela(new EstadoTelaEvent(this, new Point(0, 0), 60));
        this.listaDesenhoVisivel = new Vector();
        this.home();
    }

    public void notifyScreenChanged() {
        this.adc.enviarEvento(new GraphicOnScreenChangedEvent(this));
    }

    public void notificaAlteracaoEstado() {
        this.desenhoFuncaoController.notificaAlteracaoEstado();
        this.desenhoAnimacaoController.notificaAlteracaoEstado();
    }

    public Vector getListaDesenhoVisivel() {
        return this.listaDesenhoVisivel;
    }

    public Vector getListaFuncaoVisivel() {
        return this.desenhoFuncaoController.getListaDesenho();
    }

    public Vector getListaAnimacaoVisivel() {
        return this.desenhoAnimacaoController.getListaDesenho();
    }

    public int getCorDesenho(String string) {
        int n = 0;
        for (int i = 0; i < this.desenhoFuncaoController.getListaDesenho().size(); ++i) {
            DesenhoFuncao desenhoFuncao = (DesenhoFuncao)this.desenhoFuncaoController.getListaDesenho().get(i);
            if (!((Desenho)desenhoFuncao).getFuncaoAtual().equals(string)) continue;
            n = desenhoFuncao.getColorIndex();
        }
        return n;
    }

    public void trataDesenhoTangente(JanelaTangenteEvent janelaTangenteEvent) {
        this.desenhoTangenteController.trataEvento(janelaTangenteEvent);
    }

    public void trataMenuAnimacao(CommunicationEvent communicationEvent) {
        this.desenhoAnimacaoController.trataEvento(communicationEvent);
    }

    public void trataDesenhoTexto(CommunicationEvent communicationEvent) {
        this.desenhoTextoController.trataEvento(communicationEvent);
    }

    public void trataMenuEdicaoEvent(CommunicationEvent communicationEvent) {
        if (communicationEvent.getCommand().equals(ResourceReader.msg("madZoomAmpliar"))) {
            this.zoom(this.zoomDif);
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madZoomDiminuir"))) {
            this.zoom(-this.zoomDif);
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madZoomPadrao"))) {
            this.zoomPadrao();
        }
    }

    public void editaFuncaoTela(EdicaoExpressaoEvent edicaoExpressaoEvent) {
        String string = Utilitarios.retiraEspacos(edicaoExpressaoEvent.getFuncaoOriginal());
        for (int i = 0; i < this.listaDesenhoVisivel.size(); ++i) {
            DesenhoFuncao desenhoFuncao = (DesenhoFuncao)this.listaDesenhoVisivel.get(i);
            String string2 = Utilitarios.retiraEspacos(desenhoFuncao.getFuncaoAtual());
            if (!string2.equals(string)) continue;
            desenhoFuncao.mudaFuncao(edicaoExpressaoEvent.getFuncaoAtual());
            desenhoFuncao.setColor(edicaoExpressaoEvent.getColor());
        }
        this.notifyScreenChanged();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        if (this.cursorSobreTexto(mouseEvent)) {
            cursorSobreTexto = true;
            return;
        }
        if (this.isAnyFunctionUnderMouse(mouseEvent) != null) {
            this.xFuncao = mouseEvent.getX();
            this.yFuncao = mouseEvent.getY();
            ((Component)mouseEvent.getSource()).repaint();
        } else if (this.strokeIndex > -1) {
            this.strokeIndex = -1;
            ((Component)mouseEvent.getSource()).repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && !this.mouseOverPoint) {
            if (this.cursorSobreTexto(mouseEvent)) {
                int n = JOptionPane.showConfirmDialog(this.father, ResourceReader.msg("textRemotionOptionPaneQuestion"), ResourceReader.msg("textRemotionOptionPaneTitle"), 0);
                if (n == 0) {
                    this.desenhoTextoController.removeTexto(this.textIndex);
                    this.father.repaint();
                }
            } else {
                this.enviarEvento(new AtualizaParametroEvent(this, "show param panel"));
                return;
            }
        }
        if (this.isAnyFunctionUnderMouse(mouseEvent) != null) {
            this.moduloInferior.setStatusBarMessage(ResourceReader.msg("sbSelectedFunction") + ": " + this.functionUnderMouse.getDescricao());
            this.functionSelected = this.functionUnderMouse;
            if (mouseEvent.getClickCount() == 2) {
                GraphPlotterEvent graphPlotterEvent = new GraphPlotterEvent(this);
                graphPlotterEvent.setCommand(ResourceReader.msg("msgMenuGrfEditaExp"));
                this.enviarEvento(graphPlotterEvent);
            }
        } else {
            this.functionSelected = null;
            if (this.cursorSobreTexto(mouseEvent) && mouseEvent.getClickCount() == 2) {
                DesenhoTextoEvent desenhoTextoEvent = new DesenhoTextoEvent(this);
                DesenhoTexto desenhoTexto = (DesenhoTexto)this.desenhoTextoController.getDesenho(this.textIndex);
                desenhoTextoEvent.setDesenhoTexto(desenhoTexto);
                desenhoTextoEvent.setCommand("openEditor");
                this.desenhoTextoController.removeTexto(this.textIndex);
                this.enviarEvento(desenhoTextoEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        cursorSobreTexto = this.cursorSobreTexto(mouseEvent);
        if (!cursorSobreTexto) {
            super.mousePressed(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!cursorSobreTexto) {
            super.mouseDragged(mouseEvent);
        } else {
            this.atualizaPosicaoTexto(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.textIndex > -1) {
            // empty if block
        }
    }

    private Desenho isAnyFunctionUnderMouse(MouseEvent mouseEvent) {
        Desenho desenho = this.functionVerifyList(this.desenhoFuncaoController.getListaDesenho(), mouseEvent);
        if (desenho != null) {
            return desenho;
        }
        desenho = this.functionVerifyList(this.desenhoCalculoController.getListaDesenho(), mouseEvent);
        if (desenho != null) {
            return desenho;
        }
        this.functionUnderMouse = null;
        return null;
    }

    private Desenho functionVerifyList(Vector vector, MouseEvent mouseEvent) {
        Desenho desenho = null;
        for (int i = 0; i < vector.size(); ++i) {
            desenho = (Desenho)vector.get(i);
            this.corFuncao = desenho.getColor();
            if (!desenho.matchCoordinates(this.reverteNormalizaX(mouseEvent.getX()), this.reverteNormalizaY(mouseEvent.getY()))) continue;
            this.functionUnderMouse = desenho;
            this.strokeIndex = i;
            return desenho;
        }
        return null;
    }

    public String getExpressaoSobCursor() {
        return this.functionUnderMouse.toString();
    }

    private void atualizaPosicaoTexto(MouseEvent mouseEvent) {
        if (this.textIndex > -1) {
            this.desenhoTexto = (DesenhoTexto)this.desenhoTextoController.getListaDesenho().get(this.textIndex);
            this.desenhoTexto.setPosition(this.xPixelToReal(mouseEvent.getX()), this.yPixelToReal(mouseEvent.getY()));
            ((Component)mouseEvent.getSource()).repaint();
        }
    }

    private boolean cursorSobreTexto(MouseEvent mouseEvent) {
        int n = this.desenhoTextoController.getListaDesenho().size();
        for (int i = 0; i < n; ++i) {
            DesenhoTexto desenhoTexto = (DesenhoTexto)this.desenhoTextoController.getListaDesenho().get(i);
            if (!desenhoTexto.matchCoordinates(this.reverteNormalizaX(mouseEvent.getX()), this.reverteNormalizaY(mouseEvent.getY()))) continue;
            this.textIndex = i;
            return true;
        }
        this.textIndex = -1;
        return false;
    }

    public double getValorA() {
        return this.desenhoAnimacaoController.getValorA();
    }

    public double getValorB() {
        return this.desenhoAnimacaoController.getValorB();
    }

    public double getValorC() {
        return this.desenhoAnimacaoController.getValorC();
    }

    public double getValorM() {
        return this.desenhoAnimacaoController.getValorM();
    }

    public double getValorN() {
        return this.desenhoAnimacaoController.getValorN();
    }

    public double getValorK() {
        return this.desenhoAnimacaoController.getValorK();
    }

    class TextTask
    extends TimerTask {
        TextTask() {
        }

        public void run() {
            ++GraphPlotter.this.counter;
            if (GraphPlotter.this.counter > 4) {
                try {
                    GraphPlotter.this.desenhoTextoEvent = new DesenhoTextoEvent(this);
                    GraphPlotter.this.desenhoTextoEvent.setDesenhoTexto(GraphPlotter.this.desenhoTexto);
                    GraphPlotter.this.desenhoTextoEvent.setCommand("updatePosition");
                    GraphPlotter.this.enviarEvento(GraphPlotter.this.desenhoTextoEvent);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                GraphPlotter.this.timer.cancel();
                GraphPlotter.this.timer = null;
            }
        }
    }
}

