/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.plotter;

import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Utilitarios;
import igraf.moduloCentral.eventos.menu.IgrafMenuEdicaoEvent;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;

public class AxesPlotter
extends Plotter {
    private static final Color AxesColor = new Color(150, 120, 0);
    boolean escalaVisivel = true;
    boolean eixoVisivel = true;
    boolean gradeVisivel = true;
    private boolean axesChanged = false;

    public void desenha(Graphics2D graphics2D, int n, int n2) {
        super.dimensiona(graphics2D, n, n2);
        this.clearScreen(graphics2D, n, n2);
        this.desenha(graphics2D);
    }

    private void clearScreen(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setPaint(Color.black);
    }

    private void desenha(Graphics2D graphics2D) {
        if (this.isEixoVisivel()) {
            this.eixosCoordenados(graphics2D);
        }
        if (this.isEscalaVisivel()) {
            this.escala(graphics2D);
        }
        if (this.isGradeVisivel()) {
            this.grade(graphics2D);
        }
        if (this.drawHotPoint) {
            this.drawHotPoint(graphics2D);
        }
    }

    private void grade(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3 = this.getPasso();
        graphics2D.setColor(Color.LIGHT_GRAY);
        for (n2 = -n3; n2 >= this.xmin + this.getTranslationX(); n2 -= n3) {
            graphics2D.drawLine(this.normalizaX(n2), 0, this.normalizaX(n2), this.height);
        }
        for (n = -n3; n >= this.ymin - this.getTranslationY(); n -= n3) {
            graphics2D.drawLine(0, this.normalizaY(n), this.width, this.normalizaY(n));
        }
        for (n2 = 0; n2 <= this.xmax + this.getTranslationX(); n2 += n3) {
            graphics2D.drawLine(this.normalizaX(n2), 0, this.normalizaX(n2), this.height);
        }
        for (n = 0; n <= this.ymax - this.getTranslationY(); n += n3) {
            graphics2D.drawLine(0, this.normalizaY(n), this.width, this.normalizaY(n));
        }
    }

    private void escala(Graphics2D graphics2D) {
        int n;
        int n2;
        for (n2 = this.getPasso(); n2 <= this.xmax + this.getTranslationX(); n2 += this.passo) {
            graphics2D.drawString("" + Utilitarios.precisao((float)n2 / (float)this.escala), this.normalizaX(n2), this.normalizaY(-12));
        }
        for (n2 = -this.passo; n2 >= this.xmin + this.getTranslationX(); n2 -= this.passo) {
            graphics2D.drawString("" + Utilitarios.precisao((float)n2 / (float)this.escala), this.normalizaX(n2), this.normalizaY(-12));
        }
        for (n = -this.passo; n >= this.ymin - this.getTranslationY(); n -= this.passo) {
            graphics2D.drawString("" + Utilitarios.precisao((float)n / (float)this.escala), this.normalizaX(10), this.normalizaY(n));
        }
        for (n = this.passo; n <= this.ymax - this.getTranslationY(); n += this.passo) {
            graphics2D.drawString("" + Utilitarios.precisao((float)n / (float)this.escala), this.normalizaX(10), this.normalizaY(n));
        }
    }

    private int getPasso() {
        int n = 1;
        int n2 = this.escala / this.passoMinimo;
        if (this.passo > 2 * this.passoMinimo) {
            n *= 2;
        }
        this.passo = this.escala;
        return this.escala;
    }

    private void eixosCoordenados(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(AxesColor);
        int n = this.normalizaY(0);
        graphics2D.drawLine(0, n, this.width, n);
        n = this.normalizaX(0);
        graphics2D.drawLine(n, 0, n, this.height);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.black);
    }

    private void desenhaSetas(Graphics2D graphics2D, int n, int n2) {
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        polygon.addPoint(n - 1, 0);
        polygon.addPoint(n - 8, -4);
        polygon.addPoint(n - 8, 4);
        polygon2.addPoint(0, -n2 + 2);
        polygon2.addPoint(-4, -n2 + 8);
        polygon2.addPoint(4, -n2 + 8);
        graphics2D.fillPolygon(polygon);
        graphics2D.fillPolygon(polygon2);
        graphics2D.drawString("x", n - 8, -11);
        graphics2D.drawString("y", 10, -n2 + 10);
    }

    private void drawHotPoint(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.yellow);
        graphics2D.fillOval(this.hotPointX - 4, this.hotPointY - 4, 8, 8);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(this.hotPointX - 4, this.hotPointY - 4, 8, 8);
        graphics2D.setColor(color);
    }

    public void alteraVisibilidadeGrade() {
        this.gradeVisivel = !this.gradeVisivel;
        this.enviarEvento(new IgrafMenuEdicaoEvent(this, "Alternate between show, or not, the grid on screen"));
    }

    private boolean isGradeVisivel() {
        return this.gradeVisivel;
    }

    public void alteraVisibilidadeEixo() {
        this.eixoVisivel = !this.eixoVisivel;
        this.enviarEvento(new IgrafMenuEdicaoEvent(this, "Alternate between show, or not, the axes on screen"));
    }

    private boolean isEixoVisivel() {
        return this.eixoVisivel;
    }

    public void alteraVisibilidadeEscala() {
        this.escalaVisivel = !this.escalaVisivel;
        this.enviarEvento(new IgrafMenuEdicaoEvent(this, "Alternate between show, or not, the axes with scale"));
    }

    private boolean isEscalaVisivel() {
        return this.escalaVisivel;
    }

    private void gradePadrao() {
        this.eixoVisivel = true;
        this.gradeVisivel = true;
        this.escalaVisivel = true;
    }

    public void resetPlotter() {
        this.gradePadrao();
    }

    public void trataMenuEdicaoEvent(CommunicationEvent communicationEvent) {
        if (communicationEvent.getCommand().equals("data loaded from file")) {
            IgrafMenuEdicaoEvent igrafMenuEdicaoEvent = (IgrafMenuEdicaoEvent)communicationEvent;
            switch (igrafMenuEdicaoEvent.getCodigoAcao()) {
                case 200: {
                    this.eixoVisivel = !this.eixoVisivel;
                    break;
                }
                case 202: {
                    this.gradeVisivel = !this.gradeVisivel;
                    break;
                }
                case 201: {
                    this.escalaVisivel = !this.escalaVisivel;
                }
            }
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madZoomAmpliar"))) {
            this.zoom(this.zoomDif);
            this.notifyScreenChanged();
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madZoomDiminuir"))) {
            this.zoom(-this.zoomDif);
            this.notifyScreenChanged();
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madZoomPadrao"))) {
            this.zoomPadrao();
            this.notifyScreenChanged();
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madEixosRemover")) || communicationEvent.getCommand().equals(ResourceReader.msg("madEixosExibir"))) {
            this.alteraVisibilidadeEixo();
            this.notifyScreenChanged();
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madEscalaRemover")) || communicationEvent.getCommand().equals(ResourceReader.msg("madEscalaExibir"))) {
            this.alteraVisibilidadeEscala();
            this.notifyScreenChanged();
        } else if (communicationEvent.getCommand().equals(ResourceReader.msg("madGradeRemover")) || communicationEvent.getCommand().equals(ResourceReader.msg("madGradeExibir"))) {
            this.alteraVisibilidadeGrade();
            this.notifyScreenChanged();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.axesChanged = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this.axesChanged = true;
    }

    public boolean axesChanged() {
        return this.axesChanged;
    }

    public void axesFixed() {
        this.axesChanged = false;
    }

    public void notifyScreenChanged() {
        this.axesChanged = true;
    }

    public int getCorDesenho(String string) {
        return 0;
    }

    public void iniciaAnimacao(boolean bl) {
    }
}

