/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.IGraf;
import igraf.basico.util.Funcao;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class DesenhoRegiaoIntegral
extends Desenho {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/desenho/DesenhoRegiaoIntegral.java";
    private double start;
    private double end;
    private double escala;
    private int fx;
    private int gx;
    private Color corPositiva = new Color(180, 100, 255);
    private Color corNegativa = new Color(255, 100, 180);
    private Color lastColor;
    private Funcao funcaoDRI;
    private String[] listaFuncoes = new String[2];
    private double[] listaResultados = new double[2];
    private boolean pintaAreaTotal;
    private String expr0;
    private String expr1;

    public DesenhoRegiaoIntegral(Plotter plotter, String[] stringArray, double d, double d2, boolean bl) {
        super(plotter, 0);
        if (this.polygonToBeDrawn == null) {
            System.err.println(IGraf.debugErrorMsg(IGCLASSPATH) + "Error: DesenhoRegiaoIntegral.DesenhoRegiaoIntegral: " + stringArray);
        }
        this.expr0 = stringArray[0];
        this.expr1 = stringArray[1];
        this.pintaAreaTotal = bl;
        this.funcaoDRI = new Funcao(1);
        this.atualizaEscala();
        this.ordenaLimitesDeIntegracao(d, d2);
    }

    private void calculaOrdenadaListaFuncao(double d) {
        for (int i = 0; i < 2; ++i) {
            this.funcaoDRI.constroiExpressao(this.getListaFuncao()[i]);
            this.listaResultados[i] = -this.funcaoDRI.f(d / this.escala) * this.escala;
        }
        this.fx = (int)this.listaResultados[0];
        this.gx = (int)this.listaResultados[1];
    }

    private String[] getListaFuncao() {
        this.listaFuncoes[0] = this.expr0;
        this.listaFuncoes[1] = this.expr1;
        return this.listaFuncoes;
    }

    private void ordenaLimitesDeIntegracao(double d, double d2) {
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        this.start = d;
        this.end = d2;
    }

    public void desenhaRegiao(Graphics graphics) {
        this.lastColor = graphics.getColor();
        graphics.setColor(this.corPositiva);
        for (double d = this.start * this.escala; d <= this.end * this.escala; d += 4.0) {
            this.calculaOrdenadaListaFuncao(d);
            graphics.drawLine(this.plotter.normalizaX((int)d), this.plotter.normalizaY(-this.fx), this.plotter.normalizaX((int)d), this.plotter.normalizaY(-this.gx));
        }
        graphics.setColor(this.lastColor);
    }

    public void desenhaRegioesDistintas(Graphics2D graphics2D) {
        this.lastColor = graphics2D.getColor();
        graphics2D.setColor(this.corPositiva);
        for (double d = this.start * this.escala; d <= this.end * this.escala; d += 4.0) {
            this.calculaOrdenadaListaFuncao(d);
            this.pintaSegmento(graphics2D, (int)d, this.fx, this.gx);
            this.pintaSegmento(graphics2D, (int)d, this.gx, this.fx);
        }
        graphics2D.setColor(this.lastColor);
    }

    private void pintaSegmento(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setColor(n2 < 0 ? this.corPositiva : this.corNegativa);
        if (n2 * n3 > 0) {
            graphics2D.drawLine(this.plotter.normalizaX(n), this.plotter.normalizaY(-n2), this.plotter.normalizaX(n), this.plotter.normalizaY(-n3));
        } else {
            graphics2D.drawLine(this.plotter.normalizaX(n), this.plotter.normalizaY(-n2), this.plotter.normalizaX(n), this.plotter.normalizaY(0));
        }
    }

    public void atualizaDesenho(Graphics2D graphics2D) {
        this.atualizaEscala();
        if (this.pintaAreaTotal) {
            this.desenhaRegiao(graphics2D);
        } else {
            this.desenhaRegioesDistintas(graphics2D);
        }
    }

    public void alteraModoPintura(boolean bl) {
        this.pintaAreaTotal = bl;
    }

    private void atualizaEscala() {
        this.escala = this.getEscala();
    }

    public String toString() {
        return "";
    }

    public String getFuncaoAtual() {
        return "";
    }

    public String getDescricao() {
        return "\u00c1rea de integra\u00e7\u00e3o entre as curvas: f(x) = " + this.listaFuncoes[0] + " e g(x) = " + this.listaFuncoes[1];
    }
}

