/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao;

import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.controle.AnimSliderController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class AnimSlider
extends Panel
implements AdjustmentListener {
    private int ini = -100;
    private int fim = 101;
    Scrollbar scroll;
    private TextField tfAtual;
    double precisao = 100.0;
    double multiplicador = 100.0;
    BorderLayout bl = new BorderLayout();
    private Panel aux;
    private Label label;
    static final Font fontHB12 = EsquemaVisual.fontHB12;
    private Dimension d = new Dimension(832, 25);

    public AnimSlider(AnimSliderController animSliderController) {
        this.aux = new Panel(new BorderLayout());
        this.label = new Label(" a = ");
        this.setBounds(0, 435, this.d.width, this.d.height);
        this.setLayout(this.bl);
        this.configureScroll(animSliderController);
        this.configureTextField();
        this.label.setFont(fontHB12);
        this.aux.add((Component)this.label, "West");
        this.add((Component)this.aux, "East");
        animSliderController.setControlledObject(this);
    }

    private void configureScroll(AnimSliderController animSliderController) {
        this.scroll = new Scrollbar(0, 0, 0, this.ini, this.fim);
        this.scroll.addAdjustmentListener(this);
        this.scroll.addAdjustmentListener(animSliderController);
        this.add(this.scroll);
    }

    private void configureTextField() {
        this.tfAtual = new TextField(){

            public Dimension getPreferredSize() {
                return new Dimension(80, 0);
            }
        };
        this.tfAtual.setForeground(Color.black);
        this.tfAtual.setEditable(false);
        this.setValue(this.ini);
        this.aux.add(this.tfAtual);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 20);
    }

    public double getValue() {
        return (double)this.scroll.getValue() / this.precisao;
    }

    public void setValue(double d) {
        this.tfAtual.setText(String.valueOf(d / this.precisao));
    }

    public void setBublePosition(double d) {
        double d2 = d * this.precisao;
        int n = (int)d2;
        this.scroll.setValue(n);
        this.setValue(d2);
    }

    public TextField getTf() {
        return this.tfAtual;
    }

    public Insets getInsets() {
        return new Insets(1, 2, 1, 2);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.tfAtual.setText(String.valueOf(this.getValue()));
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(0, rectangle.height - 165, rectangle.width, this.d.height);
    }
}

