/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.desenho;

import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.controle.PolygonDialog;
import igraf.moduloCentral.controle.desenho.DesenhoController;
import igraf.moduloCentral.controle.desenho.UndoableDrawEdit;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuPoligonoEvent;
import igraf.moduloCentral.modelo.RegularPolygonModel;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.desenho.DesenhoPoligono;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class DesenhoPoligonoController
extends DesenhoController {
    protected Vector listaDesenhoOculto = new Vector();
    public boolean modoCriacao;
    private boolean pintar = false;
    private int creationType = -1;
    public final int POINT = 0;
    public final int SEGMENT = 1;
    public final int TRIANGLE = 2;
    public final int RECTANGLE = 3;
    public final int S_RECTANGLE = 4;
    public final int POLYGON = 5;
    public final int R_POLYGON = 6;
    public final int S_POLYGON = 7;
    public final int P_POLYGON = 8;
    private RegularPolygonModel rpm;
    protected UndoableEditSupport ues = new UndoableEditSupport(this);
    protected UndoManager manager = new UndoManager();
    private DesenhoPoligono d = null;
    private String vertexList = null;
    private int vertexMode = 0;
    private int cont;
    private float vx;
    private float vy;
    private DesenhoPoligono aux;

    public DesenhoPoligonoController(Plotter plotter) {
        super(plotter);
        this.listaDesenho = new Vector();
        this.ues.addUndoableEditListener(this.manager);
    }

    public void postNewEdit() {
        UndoableDrawEdit undoableDrawEdit = new UndoableDrawEdit(this);
        this.ues.postEdit(undoableDrawEdit);
    }

    public boolean undo() {
        try {
            this.manager.undo();
            this.notificaAlteracaoEstado();
            return true;
        }
        catch (CannotUndoException cannotUndoException) {
            System.err.println("n\u00e3o existem a\u00e7\u00f5es a desfazer");
            return false;
        }
    }

    public boolean redo() {
        try {
            this.manager.redo();
            this.notificaAlteracaoEstado();
            return true;
        }
        catch (CannotRedoException cannotRedoException) {
            System.err.println("n\u00e3o existem a\u00e7\u00f5es desfeitas a refazer");
            return false;
        }
    }

    public Vector getListaDesenhoSemReferencia() {
        Vector<DesenhoPoligono> vector = new Vector<DesenhoPoligono>();
        if (this.listaDesenho.size() > 0) {
            for (int i = 0; i < this.listaDesenho.size(); ++i) {
                DesenhoPoligono desenhoPoligono = new DesenhoPoligono((DesenhoPoligono)this.listaDesenho.get(i));
                vector.add(desenhoPoligono);
            }
        }
        return vector;
    }

    private void resetUndoManager() {
        this.manager.discardAllEdits();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void trataEvento(CommunicationEvent communicationEvent) {
        if (communicationEvent.getCommand().equals("undo_polygon") || communicationEvent.getCommand().equals("redo_polygon") || communicationEvent.getCommand().equals("draw_polygon")) {
            return;
        }
        String string = communicationEvent.getCommand();
        this.modoCriacao = true;
        if (string.equals(ResourceReader.msg("msgMenuGrfNovaSes"))) {
            this.reset();
            this.resetUndoManager();
            return;
        }
        if (string.equals(ResourceReader.msg("mepPonto"))) {
            this.creationType = 0;
            return;
        } else if (string.equals(ResourceReader.msg("mepSegm"))) {
            this.creationType = 1;
            return;
        } else if (string.equals(ResourceReader.msg("mepTri"))) {
            this.creationType = 2;
            return;
        } else if (string.equals(ResourceReader.msg("mepRet"))) {
            this.creationType = 3;
            return;
        } else if (string.equals(ResourceReader.msg("mepRetEsp"))) {
            this.creationType = 4;
            return;
        } else if (string.equals(ResourceReader.msg("mepPolQqr"))) {
            this.creationType = 5;
            return;
        } else if (string.equals(ResourceReader.msg("mepPolReg"))) {
            this.creationType = 6;
            PolygonDialog polygonDialog = new PolygonDialog(null);
            if (!polygonDialog.dataValidated()) return;
            this.rpm = new RegularPolygonModel(polygonDialog.getApotema(), polygonDialog.getVertexNum());
            return;
        } else if (string.equals(ResourceReader.msg("mepPolEsp"))) {
            this.creationType = 7;
            return;
        } else {
            if (!string.equals(ResourceReader.msg("mepPintaPoli")) && !string.equals(ResourceReader.msg("mepNPintaPoli"))) return;
            this.pintar = !this.pintar;
            this.plotter.setPaintMode(this.pintar);
            this.modoCriacao = false;
        }
    }

    public boolean inserePoligono(Desenho desenho) {
        this.postNewEdit();
        if (desenho.ok) {
            this.listaDesenho.add(desenho);
            this.listaDesenhoOculto.add(desenho);
            this.notificaAlteracaoEstado();
            return true;
        }
        return false;
    }

    public void removeDesenho(Desenho desenho) {
        this.listaDesenhoOculto.remove(desenho);
        this.listaDesenho.remove(desenho);
        this.notificaAlteracaoEstado();
    }

    public void removeDesenho() {
        if (this.creationType != 0) {
            try {
                this.listaDesenhoOculto.removeElementAt(this.listaDesenhoOculto.size() - 1);
                this.listaDesenho.removeElementAt(this.listaDesenho.size() - 1);
                this.notificaAlteracaoEstado();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removerTodos() {
        this.listaDesenhoOculto.removeAllElements();
        this.listaDesenho.removeAllElements();
        this.notificaAlteracaoEstado();
    }

    public void desenharTodos() {
        for (int i = 0; i < this.listaDesenhoOculto.size(); ++i) {
            this.d = (DesenhoPoligono)this.listaDesenhoOculto.get(i);
            this.listaDesenho.add(this.d);
        }
        this.notificaAlteracaoEstado();
    }

    public void ocultaDesenho(Desenho desenho) {
        this.listaDesenho.remove(desenho);
    }

    public void ocultaTodosGraficos() {
        this.listaDesenho.removeAllElements();
        this.notificaAlteracaoEstado();
    }

    public Vector getListaDesenhoOculto() {
        return this.listaDesenhoOculto;
    }

    public void insereVertice(int n, int n2) {
        if (this.modoCriacao) {
            float f = this.plotter.xPixelToReal(n);
            float f2 = this.plotter.yPixelToReal(n2);
            switch (this.creationType) {
                case 0: {
                    this.criaPonto(f, f2);
                    break;
                }
                case 1: {
                    this.criaPoligono(f, f2, 2, 0);
                    break;
                }
                case 2: {
                    this.criaPoligono(f, f2, 3, 0);
                    break;
                }
                case 3: {
                    this.criaRetangulo(f, f2, 0);
                    break;
                }
                case 4: {
                    this.criaRetanguloEspecial(f, f2, 1);
                    break;
                }
                case 6: {
                    this.criaPoligonoRegular(f, f2);
                    break;
                }
                case 5: {
                    this.criaPoligono(f, f2, 2012, 0);
                    break;
                }
                case 7: {
                    this.criaPoligonoEspecial(f, f2, 2012, 1);
                }
            }
        }
    }

    public String getVertexList() {
        return this.vertexList;
    }

    public int getPolygonType() {
        return this.creationType == 6 ? 1 : 0;
    }

    private void criaPonto(float f, float f2) {
        this.d = new DesenhoPoligono(this.plotter, "[(" + f + "," + f2 + ")]", 0, this.plotter.isInPaintMode(), 0);
        this.inserePoligono(this.d);
        this.encerraModoEntrada();
    }

    private void criaPoligono(float f, float f2, int n, int n2) {
        if (this.d == null) {
            this.d = new DesenhoPoligono(this.plotter, "[(" + f + "," + f2 + ")]", 0, this.plotter.isInPaintMode(), n2);
            this.vertexMode = n2;
            this.inserePoligono(this.d);
            this.cont = 1;
        } else {
            if (this.cont++ < n) {
                this.d.insereVertice(f, f2);
                this.notificaAlteracaoEstado();
            }
            if (this.cont == n) {
                this.encerraModoEntrada();
            }
        }
    }

    private void criaRetangulo(float f, float f2, int n) {
        if (this.d == null) {
            this.d = new DesenhoPoligono(this.plotter, "[(" + f + "," + f2 + ")]", 0, this.plotter.isInPaintMode(), n);
            this.vertexMode = n;
            this.inserePoligono(this.d);
            this.vx = f;
            this.vy = f2;
        } else {
            this.d.insereVertice(this.vx, f2);
            this.d.insereVertice(f, f2);
            this.d.insereVertice(f, this.vy);
            this.notificaAlteracaoEstado();
            this.encerraModoEntrada();
        }
    }

    private void criaPoligonoEspecial(float f, float f2, int n, int n2) {
        this.criaPoligono(Math.round(f), Math.round(f2), n, n2);
    }

    private void criaRetanguloEspecial(float f, float f2, int n) {
        this.criaRetangulo(Math.round(f), Math.round(f2), n);
    }

    private void criaPoligonoRegular(float f, float f2) {
        if (this.rpm == null) {
            this.modoPadrao();
            return;
        }
        float f3 = this.rpm.getApotema();
        int n = this.rpm.getNumVertex();
        float f4 = 360.0f / (float)n;
        double d = Math.toRadians(f4);
        float f5 = f3 / (float)Math.cos(d / 2.0);
        this.d = new DesenhoPoligono(this.plotter, "[(" + f + "," + (f2 + f5) + ")]", 0, this.plotter.isInPaintMode(), 0);
        this.inserePoligono(this.d);
        Point2D point2D = new Point2D.Double(f, f2 + f5);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, f, f2);
        for (int i = 1; i < n; ++i) {
            point2D = affineTransform.transform(point2D, null);
            float f6 = (float)point2D.getX();
            float f7 = (float)point2D.getY();
            this.d.insereVertice(f6, f7);
        }
        this.encerraModoEntrada();
    }

    public void encerraModoEntrada() {
        this.vertexList = this.d.toString();
        this.plotter.enviarEvento(new IgrafMenuPoligonoEvent(this, "draw_polygon"));
        this.modoPadrao();
    }

    public void modoPadrao() {
        this.modoCriacao = false;
        this.vertexMode = 0;
        this.cont = 2012;
        this.d = null;
    }

    public void notificaAlteracaoEstado() {
        IgrafTabUpdateEvent igrafTabUpdateEvent = new IgrafTabUpdateEvent(this, "changePolygonList");
        igrafTabUpdateEvent.notificaDesenhoOculto(this.listaDesenhoOculto.size() > 0);
        igrafTabUpdateEvent.setPolygonList(this.listaDesenho);
        igrafTabUpdateEvent.polygonListChanged(true);
        this.enviarEvento(igrafTabUpdateEvent);
    }

    public int getCreationType() {
        return this.creationType;
    }

    public String getLineColorToStringRGB() {
        return this.d.getLineColorToStringRGB();
    }

    public String getFillColorToStringRGB() {
        return this.d.getFillColorToStringRGB();
    }

    public int getFillingMode() {
        return this.d.isFilledPolygon() ? 1 : 0;
    }

    public boolean look4Point(float f, float f2) {
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            this.aux = (DesenhoPoligono)this.listaDesenho.get(i);
            if (!this.aux.mouseOverVertex(f, f2)) continue;
            return true;
        }
        return false;
    }

    public void dragPoint(int n, int n2) {
        this.aux.changeVertex(this.plotter.xPixelToReal(n), this.plotter.yPixelToReal(n2));
    }

    public int getVertexMode() {
        return this.vertexMode;
    }
}

