/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloAjuda.visao;

import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloAjuda.modelo.TextoAnimacao;
import igraf.moduloAjuda.modelo.TextoCalculo;
import igraf.moduloAjuda.modelo.TextoConceito;
import igraf.moduloAjuda.modelo.TextoEdicoes;
import igraf.moduloAjuda.modelo.TextoExercicio;
import igraf.moduloAjuda.modelo.TextoGrafico;
import igraf.moduloAjuda.modelo.TextoSintaxe;
import igraf.moduloAjuda.visao.navegador.ItemNavigator;
import igraf.moduloAjuda.visao.navegador.LinearNavigator;
import igraf.moduloAjuda.visao.navegador.PainelConteudo;
import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class Help
extends JFrame {
    private static final int HELPWIDTH = 798;
    private static final int HELPHEIGHT = 600;
    public static final int TOPICSWIDTH = 620;
    public static final int TOPICHEIGHT = 30;
    public static final int MARGIN = 26;
    public static final int PANELMENUITEMWIDTH = 120;
    public static final int BUTTONWIDTH = 88;
    public static final int BUTTONHEIGHT = 40;
    public static final int MENUITEMWIDTH = 118;
    public static final int MENUITEMHEIGHT = 40;
    public static final int BASICFONTSIZE = 12;
    private JScrollPane listScrollPane;
    private JSplitPane splitPane;
    private LinearNavigator linear;
    private ItemNavigator item;
    private PainelConteudo conteudo;

    public Help() {
        super("iGraf: " + ResourceReader.msg("manualTitleWindow"));
        this.setSize(798, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.linear = new LinearNavigator();
        this.item = new ItemNavigator();
        this.conteudo = new PainelConteudo();
        this.linear.addNavigatorPanelListener(this.conteudo);
        this.linear.addNavigatorPanelListener(this.item);
        this.item.addNavigatorPanelListener(this.conteudo);
        this.item.addNavigatorPanelListener(this.linear);
        this.listScrollPane = new JScrollPane(this.conteudo);
        this.listScrollPane.setViewportBorder(BorderFactory.createBevelBorder(1));
        this.splitPane = new JSplitPane(1, this.item, this.listScrollPane);
        this.listScrollPane.setBackground(EsquemaVisual.corFundoParagrafos);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(120);
        this.getContentPane().add("North", this.linear);
        this.getContentPane().add("Center", this.splitPane);
        this.insereWindowListener();
        this.setVisible(true);
    }

    private void insereWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Help.this.fechaJanela();
            }
        });
    }

    private void fechaJanela() {
        this.setVisible(false);
        this.dispose();
    }

    public Insets getInsets() {
        return new Insets(12, 7, 7, 7);
    }

    public void updateLabels() {
        this.setTitle("iGraf: " + ResourceReader.msg("manualTitleWindow"));
        TextoGrafico.updateLabels();
        TextoCalculo.updateLabels();
        TextoAnimacao.updateLabels();
        TextoEdicoes.updateLabels();
        TextoExercicio.updateLabels();
        TextoSintaxe.updateLabels();
        TextoConceito.updateLabels();
        this.linear.updateLabels();
    }

    public static void main(String[] stringArray) {
        new Help();
    }
}

