/*
 * Decompiled with CFR 0.152.
 */
package igraf.edu.hws.jcm.data;

public class NumUtils {
    public static double stringToReal(String string) {
        try {
            Double d = new Double(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static String realToString(double d) {
        return NumUtils.realToString(d, 10);
    }

    public static String realToString(double d, int n) {
        n = Math.min(25, Math.max(6, n));
        if (Double.isNaN(d)) {
            return "undefined";
        }
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return "-INF";
            }
            return "INF";
        }
        String string = String.valueOf(d);
        if (Math.rint(d) == d && Math.abs(d) < 5.0E15 && string.length() <= n + 2) {
            return String.valueOf((long)d);
        }
        if (string.length() <= n) {
            return string;
        }
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d = -d;
            --n;
            string = String.valueOf(d);
        }
        long l = 5L * (long)Math.pow(10.0, n - 2);
        if (d >= 5.0E-4 && d <= (double)l && string.indexOf(69) == -1 && string.indexOf(101) == -1) {
            string = NumUtils.round(string, n);
            string = NumUtils.trimZeros(string);
        } else if (d > 1.0) {
            long l2 = (long)Math.floor(Math.log(d) / Math.log(10.0));
            String string2 = "E" + l2;
            int n2 = n - string2.length();
            string = String.valueOf(d /= Math.pow(10.0, l2));
            string = NumUtils.round(string, n2);
            string = NumUtils.trimZeros(string);
            string = string + string2;
        } else {
            long l3 = (long)Math.ceil(-Math.log(d) / Math.log(10.0));
            String string3 = "E-" + l3;
            int n3 = n - string3.length();
            string = String.valueOf(d *= Math.pow(10.0, l3));
            string = NumUtils.round(string, n3);
            string = NumUtils.trimZeros(string);
            string = string + string3;
        }
        if (bl) {
            return "-" + string;
        }
        return string;
    }

    private static String trimZeros(String string) {
        if (string.indexOf(46) >= 0 && string.charAt(string.length() - 1) == '0') {
            int n = string.length() - 1;
            while (string.charAt(n) == '0') {
                --n;
            }
            string = string.charAt(n) == '.' ? string.substring(0, n) : string.substring(0, n + 1);
        }
        return string;
    }

    private static String round(String string, int n) {
        if (string.indexOf(46) < 0) {
            return string;
        }
        if (string.length() <= n) {
            return string;
        }
        if (string.charAt(n) >= '5' && string.charAt(n) != '.') {
            char[] cArray = new char[n + 1];
            int n2 = n;
            boolean bl = true;
            for (int i = n - 1; i >= 0; --i) {
                cArray[n2] = string.charAt(i);
                if (bl && cArray[n2] != '.') {
                    if (cArray[n2] < '9') {
                        int n3 = n2;
                        cArray[n3] = (char)(cArray[n3] + '\u0001');
                        bl = false;
                    } else {
                        cArray[n2] = 48;
                    }
                }
                --n2;
            }
            if (bl) {
                cArray[n2] = 49;
                --n2;
            }
            return new String(cArray, n2 + 1, n - n2);
        }
        return string.substring(0, n);
    }
}

