/*
 * Decompiled with CFR 0.152.
 */
package difusor;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class ResourceReader {
    private static ResourceBundle resourceBundleGeneralMessages;
    public static String lingua;
    public static String pais;
    public static int PORTUGUESE;
    public static int ENGLISH;
    private static Vector vecErros;

    public ResourceReader() {
        resourceBundleGeneralMessages = ResourceBundle.getBundle("resources/StringsTable_pt_BR");
    }

    public ResourceReader(String string) {
        resourceBundleGeneralMessages = ResourceBundle.getBundle(string);
    }

    public static void setLanguage(int n) {
        Locale locale = null;
        if (n == PORTUGUESE) {
            locale = new Locale("pt", "BR");
        }
        if (n == ENGLISH) {
            locale = new Locale("en", "US");
        }
        resourceBundleGeneralMessages = ResourceBundle.getBundle("resources/StringsTable", locale);
    }

    public static String getString(String string) {
        try {
            return resourceBundleGeneralMessages.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Erro: falta a mensagem '" + string + "' em 'util/StringsTable*.properties'!");
            if (!vecErros.contains(string)) {
                missingResourceException.printStackTrace();
                vecErros.addElement(string);
                return "Falta mensagem: " + string;
            }
            return "";
        }
        catch (Exception exception) {
            System.err.println("Erro: na mensagem '" + string + "': " + exception);
            return "Falta mensagem: " + string;
        }
    }

    static {
        lingua = "";
        pais = "";
        PORTUGUESE = 0;
        ENGLISH = 1;
        vecErros = new Vector();
    }
}

